#include "layer_status_repository_internal.h"

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

namespace NInfra::NPodAgent::NLayerStatusRepositoryInternalTest {

Y_UNIT_TEST_SUITE(LayerStatusRepositoryInternalSuite) {

Y_UNIT_TEST(TestAddLayer) {
    TLayerStatusRepositoryInternalPtr holder = new TLayerStatusRepositoryInternal();
    const TString id = "my_layer";
    const TString hash = "my_hash";

    UNIT_ASSERT(!holder->HasObject(id));
    UNIT_ASSERT(!holder->HasHash(hash));

    holder->AddObjectWithHash(id, hash);
    UNIT_ASSERT(holder->HasObject(id));
    UNIT_ASSERT(holder->HasHash(hash));
    UNIT_ASSERT(!holder->HasHash(hash + "_other"));

    holder->RemoveObject(id);
    UNIT_ASSERT(!holder->HasObject(id));
    UNIT_ASSERT(!holder->HasHash(hash));
}

Y_UNIT_TEST(TestGetHash) {
    TLayerStatusRepositoryInternalPtr holder = new TLayerStatusRepositoryInternal();
    const TString id = "my_layer";
    const TString hash = "my_hash";
    holder->AddObjectWithHash(id, hash);

    UNIT_ASSERT_EQUAL_C(holder->GetObjectHash(id), hash, holder->GetObjectHash(id));
    UNIT_ASSERT_EQUAL(holder->GetObjectIdsByHash(hash), TVector<TString>({id}));
}

Y_UNIT_TEST(TestExceptions) {
    TLayerStatusRepositoryInternalPtr holder = new TLayerStatusRepositoryInternal();
    const TString id = "my_layer";
    const TString hash = "my_hash";

    UNIT_ASSERT_EXCEPTION_CONTAINS(holder->GetObjectHash(id), yexception, ToString(EStatusRepositoryType::LAYER_STATUS_REPOSITORY));
    UNIT_ASSERT_EQUAL(holder->GetObjectIdsByHash(hash), TVector<TString>());
}

Y_UNIT_TEST(TestHashCollision) {
    TLayerStatusRepositoryInternalPtr holder = new TLayerStatusRepositoryInternal();
    const TString id1 = "my_layer1";
    const TString id2 = "my_layer2";
    const TString hash = "my_hash";

    holder->AddObjectWithHash(id1, hash);
    holder->AddObjectWithHash(id2, hash);

    UNIT_ASSERT_EQUAL(holder->GetObjectIdsByHash(hash), TVector<TString>({id1, id2})); // id1 < id2

    holder->RemoveObject(id2);
    UNIT_ASSERT(holder->HasObject(id1));
    UNIT_ASSERT(!holder->HasObject(id2));
    UNIT_ASSERT(holder->HasHash(hash));
    UNIT_ASSERT_EQUAL(holder->GetObjectIdsByHash(hash), TVector<TString>({id1}));

    holder->RemoveObject(id1);
    UNIT_ASSERT(!holder->HasObject(id1));
    UNIT_ASSERT(!holder->HasObject(id2));
    UNIT_ASSERT(!holder->HasHash(hash));
    UNIT_ASSERT_EQUAL(holder->GetObjectIdsByHash(hash), TVector<TString>());
}

}

}; // namespace NInfra::NPodAgent::NLayerStatusRepositoryInternalTest
