#include "object_container_status_repository_internal.h"

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

namespace NInfra::NPodAgent::NObjectContainerStatusRepositoryInternalTest {

Y_UNIT_TEST_SUITE(ObjectContainerStatusRepositoryInternalSuite) {

Y_UNIT_TEST(TestAdd) {
    TLayerContainerStatusRepositoryInternalPtr holder = new TLayerContainerStatusRepositoryInternal();
    const TString id = "my_layer";

    UNIT_ASSERT(!holder->HasObject(id));

    holder->AddObject(id);
    UNIT_ASSERT(holder->HasObject(id));

    holder->RemoveObject(id);
    UNIT_ASSERT(!holder->HasObject(id));
}

Y_UNIT_TEST(TestAddWithInit) {
    TWorkloadContainerStatusRepositoryInternalPtr holder = new TWorkloadContainerStatusRepositoryInternal();
    const TString id = "my_workload";

    UNIT_ASSERT(!holder->HasObject(id));

    holder->AddObject(id);
    UNIT_ASSERT(holder->HasObject(id));

    holder->RemoveObject(id);
    UNIT_ASSERT(!holder->HasObject(id));
}

Y_UNIT_TEST(TestContainer) {
    TLayerContainerStatusRepositoryInternalPtr holder = new TLayerContainerStatusRepositoryInternal();
    const TString id = "my_layer";
    holder->AddObject(id);

    NStatusRepositoryTypes::TContainerDescription containerDownload = NStatusRepositoryTypes::TContainerDescription{
        id
        , NStatusRepositoryTypes::EObjectType::LAYER
        , NStatusRepositoryTypes::TContainerDescription::EContainerType::DOWNLOAD
    };
    NStatusRepositoryTypes::TContainerDescription containerVerify = NStatusRepositoryTypes::TContainerDescription{
        id
        , NStatusRepositoryTypes::EObjectType::LAYER
        , NStatusRepositoryTypes::TContainerDescription::EContainerType::VERIFY
    };


    holder->IncrementContainerZeroReturnCodeCounter(containerDownload);
    holder->IncrementContainerPositiveReturnCodeCounter(containerVerify);

    UNIT_ASSERT_EQUAL_C(holder->GetContainerZeroReturnCodeCounter(containerDownload), 1, holder->GetContainerZeroReturnCodeCounter(containerDownload));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerPositiveReturnCodeCounter(containerDownload), 0, holder->GetContainerPositiveReturnCodeCounter(containerDownload));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerOomCounter(containerDownload), 0, holder->GetContainerOomCounter(containerDownload));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerKilledExternallyCounter(containerDownload), 0, holder->GetContainerKilledExternallyCounter(containerDownload));

    UNIT_ASSERT_EQUAL_C(holder->GetContainerZeroReturnCodeCounter(containerVerify), 0, holder->GetContainerZeroReturnCodeCounter(containerVerify));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerPositiveReturnCodeCounter(containerVerify), 1, holder->GetContainerPositiveReturnCodeCounter(containerVerify));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerOomCounter(containerVerify), 0, holder->GetContainerOomCounter(containerVerify));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerKilledExternallyCounter(containerVerify), 0, holder->GetContainerKilledExternallyCounter(containerVerify));
}

Y_UNIT_TEST(TestContainerWithInit) {
    TWorkloadContainerStatusRepositoryInternalPtr holder = new TWorkloadContainerStatusRepositoryInternal();
    const TString id = "my_workload";
    holder->AddObject(id);

    NStatusRepositoryTypes::TContainerDescription containerStart = NStatusRepositoryTypes::TContainerDescription(
        id
        , NStatusRepositoryTypes::EObjectType::WORKLOAD
        , NStatusRepositoryTypes::TContainerDescription::EContainerType::START
    );
    NStatusRepositoryTypes::TContainerDescription containerStop = NStatusRepositoryTypes::TContainerDescription(
        id
        , NStatusRepositoryTypes::EObjectType::WORKLOAD
        , NStatusRepositoryTypes::TContainerDescription::EContainerType::STOP
    );
    NStatusRepositoryTypes::TContainerDescription containerInit0 = NStatusRepositoryTypes::TContainerDescription(
        id
        , NStatusRepositoryTypes::EObjectType::WORKLOAD
        , NStatusRepositoryTypes::TContainerDescription::EContainerType::INIT
        , 0
    );
    NStatusRepositoryTypes::TContainerDescription containerInit1 = NStatusRepositoryTypes::TContainerDescription(
        id
        , NStatusRepositoryTypes::EObjectType::WORKLOAD
        , NStatusRepositoryTypes::TContainerDescription::EContainerType::INIT
        , 1
    );

    holder->IncrementContainerZeroReturnCodeCounter(containerStart);
    holder->IncrementContainerPositiveReturnCodeCounter(containerStop);
    holder->IncrementContainerOomCounter(containerInit0);
    holder->IncrementContainerKilledExternallyCounter(containerInit1);

    UNIT_ASSERT_EQUAL_C(holder->GetContainerZeroReturnCodeCounter(containerStart), 1, holder->GetContainerZeroReturnCodeCounter(containerStart));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerPositiveReturnCodeCounter(containerStart), 0, holder->GetContainerPositiveReturnCodeCounter(containerStart));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerOomCounter(containerStart), 0, holder->GetContainerOomCounter(containerStart));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerKilledExternallyCounter(containerStart), 0, holder->GetContainerKilledExternallyCounter(containerStart));

    UNIT_ASSERT_EQUAL_C(holder->GetContainerZeroReturnCodeCounter(containerStop), 0, holder->GetContainerZeroReturnCodeCounter(containerStop));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerPositiveReturnCodeCounter(containerStop), 1, holder->GetContainerPositiveReturnCodeCounter(containerStop));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerOomCounter(containerStop), 0, holder->GetContainerOomCounter(containerStop));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerKilledExternallyCounter(containerStop), 0, holder->GetContainerKilledExternallyCounter(containerStop));

    UNIT_ASSERT_EQUAL_C(holder->GetContainerZeroReturnCodeCounter(containerInit0), 0, holder->GetContainerZeroReturnCodeCounter(containerInit0));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerPositiveReturnCodeCounter(containerInit0), 0, holder->GetContainerPositiveReturnCodeCounter(containerInit0));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerOomCounter(containerInit0), 1, holder->GetContainerOomCounter(containerInit0));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerKilledExternallyCounter(containerInit0), 0, holder->GetContainerKilledExternallyCounter(containerInit0));

    UNIT_ASSERT_EQUAL_C(holder->GetContainerZeroReturnCodeCounter(containerInit1), 0, holder->GetContainerZeroReturnCodeCounter(containerInit1));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerPositiveReturnCodeCounter(containerInit1), 0, holder->GetContainerPositiveReturnCodeCounter(containerInit1));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerOomCounter(containerInit1), 0, holder->GetContainerOomCounter(containerInit1));
    UNIT_ASSERT_EQUAL_C(holder->GetContainerKilledExternallyCounter(containerInit1), 1, holder->GetContainerKilledExternallyCounter(containerInit1));
}

Y_UNIT_TEST(TestExceptions) {
    {
        TLayerContainerStatusRepositoryInternalPtr holder = new TLayerContainerStatusRepositoryInternal();
        NStatusRepositoryTypes::TContainerDescription container = NStatusRepositoryTypes::TContainerDescription(
            "no_id"
            , NStatusRepositoryTypes::EObjectType::LAYER
            , NStatusRepositoryTypes::TContainerDescription::EContainerType::DOWNLOAD
        );
        UNIT_ASSERT_EXCEPTION_CONTAINS(holder->IncrementContainerOomCounter(container), yexception, ToString(EContainerStatusRepositoryType::LAYER_CONTAINER_STATUS_REPOSITORY));
    }

    {
        TStaticResourceContainerStatusRepositoryInternalPtr holder = new TStaticResourceContainerStatusRepositoryInternal();
        NStatusRepositoryTypes::TContainerDescription container = NStatusRepositoryTypes::TContainerDescription(
            "no_id"
            , NStatusRepositoryTypes::EObjectType::STATIC_RESOURCE
            , NStatusRepositoryTypes::TContainerDescription::EContainerType::DOWNLOAD
        );
        UNIT_ASSERT_EXCEPTION_CONTAINS(holder->IncrementContainerOomCounter(container), yexception, ToString(EContainerStatusRepositoryType::STATIC_RESOURCE_CONTAINER_STATUS_REPOSITORY));
    }

    {
        TBoxContainerStatusRepositoryInternalPtr holder = new TBoxContainerStatusRepositoryInternal();
        NStatusRepositoryTypes::TContainerDescription container = NStatusRepositoryTypes::TContainerDescription(
            "no_id"
            , NStatusRepositoryTypes::EObjectType::BOX
            , NStatusRepositoryTypes::TContainerDescription::EContainerType::META
        );
        UNIT_ASSERT_EXCEPTION_CONTAINS(holder->IncrementContainerOomCounter(container), yexception, ToString(EContainerStatusRepositoryType::BOX_CONTAINER_STATUS_REPOSITORY));
    }

    {
        TWorkloadContainerStatusRepositoryInternalPtr holder = new TWorkloadContainerStatusRepositoryInternal();
        NStatusRepositoryTypes::TContainerDescription container = NStatusRepositoryTypes::TContainerDescription(
            "no_id"
            , NStatusRepositoryTypes::EObjectType::WORKLOAD
            , NStatusRepositoryTypes::TContainerDescription::EContainerType::START
        );
        UNIT_ASSERT_EXCEPTION_CONTAINS(holder->IncrementContainerOomCounter(container), yexception, ToString(EContainerStatusRepositoryType::WORKLOAD_CONTAINER_STATUS_REPOSITORY));
    }
}

}

}; // namespace NInfra::NPodAgent::NObjectContainerStatusRepositoryInternalTest
