#pragma once


namespace NInfra::NPodAgent {

// ShouldBeDestroyedByHook_ - данный флаг выставленный в true означает, что для workload должен быть вызван destroy hook
// после отработки destroy hook этот флаг выставляется в false, и мы можем менять ревизию у ворклоуда
class TWorkloadStatusInternal {
public:
    TWorkloadStatusInternal()
        : ShouldBeDestroyedByHook_(false)
    {}

    bool GetShouldBeDestroyedByHook() const {
        return ShouldBeDestroyedByHook_;
    }

    void SetShouldBeDestroyedByHook(bool shouldBeDestroyedByHook) {
        ShouldBeDestroyedByHook_ = shouldBeDestroyedByHook;
    }

private:
    bool ShouldBeDestroyedByHook_;
};

} // namespace NInfra::NPodAgent
