#include "workload_status_repository_internal.h"

#include <util/string/cast.h>

namespace NInfra::NPodAgent {

bool TWorkloadStatusRepositoryInternal::GetObjectShouldBeDestroyedByHook(const TString &objectId) const {
    TReadGuardBase<TLightRWLock> guard(GlobalLock_);
    TGuard<TMutex> g(GetObjectMutex(objectId));
    return Objects_.at(objectId).GetShouldBeDestroyedByHook();
}

void TWorkloadStatusRepositoryInternal::UpdateObjectToBeDestroyedByHook(
        const TString& objectId
        , bool shouldBeDestroyed
) {
    TReadGuardBase<TLightRWLock> guard(GlobalLock_);
    TGuard<TMutex> g(GetObjectMutex(objectId));
    const auto& workloadStatus = Objects_[objectId];
    if (workloadStatus.GetShouldBeDestroyedByHook() != shouldBeDestroyed) {
        auto& status = Objects_.at(objectId);
        status.SetShouldBeDestroyedByHook(shouldBeDestroyed);
    }
}

} // namespace NInfra::NPodAgent
