#pragma once
#include "object_status_repository_internal.h"
#include "workload_status_internal.h"

namespace NInfra::NPodAgent {

class TWorkloadStatusRepositoryInternal: public TObjectStatusRepositoryInternal<TWorkloadStatusInternal, EStatusRepositoryType::WORKLOAD_STATUS_REPOSITORY> {
public:
    TWorkloadStatusRepositoryInternal() = default;

    bool GetObjectShouldBeDestroyedByHook(const TString& objectId) const;
    void UpdateObjectToBeDestroyedByHook(const TString& objectId, bool shouldBeDestroyed);
};

using TWorkloadStatusRepositoryInternalPtr = TIntrusivePtr<TWorkloadStatusRepositoryInternal>;

} // namespace NInfra::NPodAgent
