#include "workload_status_repository_internal.h"

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

namespace NInfra::NPodAgent::NWorkloadStatusRepositoryInternalTest {

Y_UNIT_TEST_SUITE(WorkloadStatusRepositoryInternalSuite) {

Y_UNIT_TEST(TestAddWorkload) {
    TWorkloadStatusRepositoryInternalPtr holder = new TWorkloadStatusRepositoryInternal();
    const TString id = "my_workload";

    UNIT_ASSERT(!holder->HasObject(id));

    holder->AddObject(id);
    bool shouldBeDestroyedByHook = holder->GetObjectShouldBeDestroyedByHook(id);
    UNIT_ASSERT(holder->HasObject(id));
    UNIT_ASSERT(!shouldBeDestroyedByHook);

    holder->RemoveObject(id);
    UNIT_ASSERT(!holder->HasObject(id));
}

Y_UNIT_TEST(TestUpdateWorkloadState) {
    TWorkloadStatusRepositoryInternalPtr holder = new TWorkloadStatusRepositoryInternal();
    const TString id = "my_workload";

    UNIT_ASSERT(!holder->HasObject(id));

    holder->AddObject(id);
    bool shouldBeDestroyedByHook = holder->GetObjectShouldBeDestroyedByHook(id);
    UNIT_ASSERT(holder->HasObject(id));
    UNIT_ASSERT(!shouldBeDestroyedByHook);

    holder->UpdateObjectToBeDestroyedByHook(id, true);
    shouldBeDestroyedByHook = holder->GetObjectShouldBeDestroyedByHook(id);
    UNIT_ASSERT(shouldBeDestroyedByHook);
}

Y_UNIT_TEST(TestExceptions) {
    TWorkloadStatusRepositoryInternalPtr holder = new TWorkloadStatusRepositoryInternal();
    const TString id = "my_workload";

    UNIT_ASSERT_EXCEPTION_CONTAINS(holder->UpdateObjectToBeDestroyedByHook(id, true), yexception, ToString(EStatusRepositoryType::WORKLOAD_STATUS_REPOSITORY));
}

}

}; // namespace NInfra::NPodAgent::NWorkloadStatusRepositoryInternalTest
