#pragma once

#include <infra/pod_agent/libs/behaviour/template_bt_storage/template_bt_storage.h>
#include <infra/pod_agent/libs/path_util/path_holder.h>
#include <infra/pod_agent/libs/pod_agent/status_and_ticker_holder/status_and_ticker_holder.h>
#include <infra/pod_agent/libs/porto_client/async_client.h>
#include <infra/pod_agent/libs/posix_worker/posix_worker.h>

namespace NInfra::NPodAgent {

/**
    Creates behavior tree for each new layer from provided LayerTreeTemplate
    Removes unneeded trees
    Ticks trees via TMtpPeriodTicker
    Method Wait() waits for signal from Shutdown() and waits the TMtpPeriodTicker
    Method Stop() calls {Shutdown(); Wait();}
*/
class TLayerTreeGenerator {
public:
    TLayerTreeGenerator(
        TLogger& logger
        , TPathHolderPtr pathHolder
        , const TBehavior3& layerTreeTemplate
        , TAsyncPortoClientPtr porto
        , TPosixWorkerPtr posixWorker
        , TStatusNTickerHolderPtr statusNTickerHolder
        , TTemplateBTStoragePtr templateBTStorage
        , const TString& containerUser
        , const TString& containerGroup
    )
        : Logger_(logger)
        , PathHolder_(pathHolder)
        , LayerTreeTemplate_(layerTreeTemplate)
        , Porto_(porto)
        , PosixWorker_(posixWorker)
        , StatusNTickerHolder_(statusNTickerHolder)
        , TemplateBTStorage_(templateBTStorage)
        , ContainerUser_(containerUser)
        , ContainerGroup_(containerGroup)
    {}

    ~TLayerTreeGenerator() {}

public:
    struct TLayerToAdd {
        TUpdateHolder::TLayerTarget Target_;
        TString FullHash_;
        TString VirtualDiskIdRef_;
    };

    struct TLayersToAdd {
        TMap<TString, TLayerToAdd> Layers_;
    };

    struct TCacheLayersToAdd {
        TMap<TStatusRepositoryCommon::TCacheObject, TLayerToAdd> CacheLayers_;
    };

public:
    TLayerTreeGenerator::TLayersToAdd UpdateSpec(
        const API::TResourceGang& spec
        , API::EPodAgentTargetState podAgentTargetState
        , const double cpuToVcpuFactor
        , ui64 specTimestamp
        , ui32 revision
    );
    TLayerTreeGenerator::TCacheLayersToAdd UpdateResourceCache(
        const API::TPodAgentResourceCacheSpec& spec
        , API::EPodAgentTargetState podAgentTargetState
        , const API::TComputeResources& computeResources
        , const double cpuToVcpuFactor
    );

    void AddAndRemoveCacheLayers(const TCacheLayersToAdd& toAdd);

    void RemoveLayers(const TLayersToAdd& toAdd);
    void AddLayers(const TLayersToAdd& toAdd);

    void UpdateActiveDownloadContainersLimit(ui32 activeDownloadContainersLimit);

    static bool RemoveSourceFileAfterImport(API::ELayerSourceFileStoragePolicy layerSourceFileStoragePolicy, API::ELayerSourceFileStoragePolicy defaultLayerSourceFileStoragePolicy);    

protected:
    TLayerToAdd GetLayerToAdd(
        bool removeSourceFileAfterImport
        , const API::TLayer& layer
        , const API::TComputeResources& computeResources
        , const double cpuToVcpuFactor
        , ui64 specTimestamp
        , ui32 revision
    ) const;

    TString WrapLayerDownloadCommand(const TString& command) const;

    TString GetDownloadCMD(const API::TLayer& layer) const;
    TString GetDownloadCMDFromURL(const TString& url) const;
    TString GetDownloadCMDFromSkyGet(const API::TSkyGetDownload& skyGetDownload) const;

private:
    TLogger& Logger_;
    TPathHolderPtr PathHolder_;
    const TBehavior3 LayerTreeTemplate_;

    TAsyncPortoClientPtr Porto_;
    TPosixWorkerPtr PosixWorker_;
    TStatusNTickerHolderPtr StatusNTickerHolder_;
    TTemplateBTStoragePtr TemplateBTStorage_;

    const TString ContainerUser_;
    const TString ContainerGroup_;
};

} // namespace NInfra::NPodAgent
