#pragma once

#include <infra/pod_agent/libs/behaviour/bt/core/tree.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>

namespace NInfra::NPodAgent {

class TObjectTree : public TTree {
public:
    TObjectTree(
        TLogger& logger
        , const TString& treeId
        , TBasicTreeNodePtr rootNode
        , const TString& objectIdOrHash
        , TUpdateHolderTargetPtr updateHolderTarget
        , TStatusRepositoryCommonPtr statusRepositoryCommon
    )
        : TTree(logger, treeId, rootNode)
        , ObjectIdOrHash_(objectIdOrHash)
        , UpdateHolderTarget_(updateHolderTarget)
        , StatusRepositoryCommon_(statusRepositoryCommon)
    {}

    virtual bool GetUseLongTickPeriod() const override final;

private:
    const TString ObjectIdOrHash_;
    TUpdateHolderTargetPtr UpdateHolderTarget_;
    TStatusRepositoryCommonPtr StatusRepositoryCommon_;
};

} // namespace NInfra::NPodAgent
