#pragma once

#include "secret.h"

#include "box_tree_generator.h"
#include "layer_tree_generator.h"
#include "static_resource_tree_generator.h"
#include "volume_tree_generator.h"

#include <infra/pod_agent/libs/service_iface/protos/service.pb.h>

#include <google/protobuf/message_lite.h>

#include <util/generic/hash.h>

namespace NInfra::NPodAgent {

TString GetLayerDownloadHash(const API::TLayer& layer, bool removeSourceFileAfterImport);
TString GetStaticResourceDownloadHash(
    const API::TResource& resource
    , const NSecret::TSecretMap& secretMap
    , const bool autoDecodeBase64Secrets = false
);

TString GetLayerHash(const API::TLayer& layer, bool removeSourceFileAfterImport);
TString GetStaticResourceHash(
    const API::TResource& resource
    , const NSecret::TSecretMap& secretMap
    , const bool autoDecodeBase64Secrets = false
);
TString GetVolumeHash(
    const API::TVolume& volume
    , const TLayerTreeGenerator::TLayersToAdd& layers
    , const TStaticResourceTreeGenerator::TStaticResourcesToAdd& staticResources
);
TString GetBoxHash(
    const API::TBox& box
    , const TLayerTreeGenerator::TLayersToAdd& layers
    , const TStaticResourceTreeGenerator::TStaticResourcesToAdd& staticResources
    , const TVolumeTreeGenerator::TVolumesToAdd& volumes
    , const TMap<TString, TString>& systemEnv
    , const NSecret::TSecretMap& secretMap
    , const TMaybe<TString>& ytBindPath
    , const TMaybe<TString>& baseSearchBindPath
    , const TString& Ip6Address
    , bool useEnvSecret = false
    , const bool autoDecodeBase64Secrets = false
);
TString GetWorkloadHash(
    const API::TWorkload& workload
    , const NSecret::TSecretMap& secretMap
    , const TString& boxHash
    , bool useEnvSecret = false
    , const bool autoDecodeBase64Secrets = false
);

TString GetHashFromProto(const NProtoBuf::MessageLite& message);

} // namespace NInfra::NPodAgent
