#pragma once

#include <infra/pod_agent/libs/service_iface/protos/pod_agent_api.pb.h>

#include <util/generic/map.h>

namespace NInfra::NPodAgent::NSecret {

const TString BASE64_ENCODING = "base64";

struct TSecretInfo {
    TString Value_;
    TString Encoding_;

    bool operator==(const TSecretInfo& other) const {
        return Value_ == other.Value_
            && Encoding_ == other.Encoding_
        ;
    }
};

// Store secrets info: map[secret alias -> map[secret key -> secret info]]
using TSecretMap = TMap<TString, TMap<TString, TSecretInfo>>;

TSecretMap GetSecretMap(
    const google::protobuf::RepeatedPtrField<NYP::NClient::NNodes::NProto::TPodSpec::TSecret>& secrets
);

TString GetSecretValue(
    const API::SecretSelector& secret
    , const TSecretMap& secretMap
    , const bool autoDecodeBase64Secrets = false
);

TString GetMultiSecretFileContent(
    const API::TMultiSecretFileContent& secret
    , const TSecretMap& secretMap
    , const bool autoDecodeBase64Secrets = false
);

} // namespace NInfra::NPodAgent::NSecret
