#pragma once

#include "secret.h"

#include <infra/pod_agent/libs/path_util/path_holder.h>
#include <infra/pod_agent/libs/service_iface/protos/pod_agent_api.pb.h>

#include <util/generic/map.h>

namespace NInfra::NPodAgent::NSupport {

const TString HTTP_OR_HTTPS_PREFIX = "http";
const TString RBTORRENT_PREFIX = "rbtorrent";
const TString LOCAL_PREFIX = "local:";
const TString RAW_PREFIX = "raw:";

const ui64 DEFAULT_STATIC_RESOURCE_CHECK_PERIOD_MS = 180000;

// More than 34 years, in fact this is infinity
// We want to prevent dead container auto destroying by porto
const ui32 CONTAINER_AGING_TIME_SECONDS = (1 << 30);
const TString CONTAINER_CAPABILITIES_AMBIENT = "NET_BIND_SERVICE";

const TString RESOURCE_GANG_CONTAINER_LOCK = "RESOURCE_GANG_CONTAINER_LOCK";
const TString RESOURCE_DOWNLOAD_QUEUE_LOCK = "RESOURCE_DOWNLOAD_QUEUE_LOCK";
const TString RESOURCE_VERIFY_QUEUE_LOCK = "RESOURCE_VERIFY_QUEUE_LOCK";

const ui32 DEFAULT_ACTIVE_DOWNLOAD_CONTAINERS_LIMIT = 3;
const ui32 DEFAULT_ACTIVE_VERIFY_CONTAINERS_LIMIT = 100;

TString CgroupFsMountModeToString(API::ECgroupFsMountMode cgroupFsMountMode);

TString EnshieldString(const TString& str);

TString WrapDownloadCommand(const TString& command);

TString GetVerificationCommand(const TString& checksum);

TString GetVerificationChecksumValue(const TString& checksum);

TMap<TString, TString> FillVerifyResourceReplaceMap(
    const TString& name
    , const TString& checksum
    , const bool disabled = false
);

TString UnixSignalTypeToString(API::EUnixSignalType unixSignalType);

TMap<TString, TString> FillTimeLimitReplaceMap(
    const API::TTimeLimit& timeLimit
    , const TString& prefix
    , bool needDefaultInitialDelay
);

TMap<TString, TString> FillComputeResourcesReplaceMap(
    const API::TComputeResources& computeResources
    , const TString& prefix
    , const TPathHolderPtr pathHolder
    , const double cpuToVcpuFactor
);

TMap<TString, TString> FillContainerReplaceMap(
    const API::TUtilityContainer& container
    , const TString& name
    , const TString& portoContainerName
    , const TString& rootfsPath
    , const TString& podAgentBinaryFilePath
    , const google::protobuf::RepeatedPtrField<API::TEnvVar>& env
    , const NSecret::TSecretMap& secretMap
    , const TPathHolderPtr pathHolder
    , const double cpuToVcpuFactor
    , bool needTimeLimit
    , bool needValidation
    , bool useEnvSecret = false
    , bool autoDecodeBase64Secrets = false
);

TMap<TString, TString> FillInitContainersReplaceMap(
    const google::protobuf::RepeatedPtrField<API::TUtilityContainer>& containers
    , const TVector<TString>& portoContainerNames
    , const TString& rootfsPath
    , const TString& podAgentBinaryFilePath
    , const google::protobuf::RepeatedPtrField<API::TEnvVar>& env
    , const NSecret::TSecretMap& secretMap
    , const TPathHolderPtr pathHolder
    , const double cpuToVcpuFactor
    , bool useEnvSecret = false
);

TMap<TString, TString> FillReadinessOrLivenessContainerReplaceMap(
    const API::TUtilityContainer& container
    , const TString& name
    , const TString& portoContainerName
    , const TString& rootfsPath
    , const TString& podAgentBinaryFilePath
    , const google::protobuf::RepeatedPtrField<API::TEnvVar>& env
    , const NSecret::TSecretMap& secretMap
    , const TPathHolderPtr pathHolder
    , const double cpuToVcpuFactor
    , bool needTimeLimit
    , bool needValidation
    , bool useEnvSecret = false
);

TMap<TString, TString> GetCommonSystemEnvironment(
    const TString& tvmToolLocalToken
    , const TString& podId
    , const API::TNodeMeta& nodeMeta
    , const API::TGpuManagerMeta& gpuManagerMeta
    , const NYP::NClient::NApi::NProto::TPodStatus::TDns& dns
    , const google::protobuf::RepeatedPtrField<NYP::NClient::NApi::NProto::TPodStatus::TIP6AddressAllocation>& ip6AddressAllocations
);

TMap<TString, TString> GetContainerSpecificSystemEnvironment(
    const TString& containerName
);

void ValidateNoCollisionWithSystemEnvironment(
    const google::protobuf::RepeatedPtrField<API::TEnvVar>& env
);

TString EnvironmentMapToString(const TMap<TString, TString>& envMap);

struct TEnvironmentList {
    TString PublicEnv_;
    TString SecretEnv_;
};

TEnvironmentList GetEnvironmentList(
    const google::protobuf::RepeatedPtrField<API::TEnvVar>& env
    , const NSecret::TSecretMap& secretMap
    , const TMap<TString, TString>& systemEnv
    , bool useEnvSecret = false
    , bool autoDecodeBase64Secrets = false
);

TString GetULimitList(
    const google::protobuf::RepeatedPtrField<API::TUlimitSoft>& ulimitSoft
);

TString GetSkyGetDownloadCommand(
    const API::TSkyGetDownload& skyGetDownload
    , const TString& downloadDir
);

bool IsUrl(TStringBuf req);

bool IsRbtorrent(const TString& url);

bool IsWgetOrSkyget(TStringBuf req);

// Removes slash from the beginning and from the end
TString NormalizeMountPoint(const TString& mountPoint);

// Check that mount points are correct and not nested
void ValidateMountPoints(const TVector<TString>& mountPoints);

} // namespace NInfra::NPodAgent::NSupport
