#pragma once

#include "support_functions.h"
#include "test_functions.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/test_functions.h>
#include <infra/pod_agent/libs/pod_agent/status_and_ticker_holder/status_and_ticker_holder.h>
#include <infra/pod_agent/libs/path_util/path_holder.h>
#include <infra/pod_agent/libs/porto_client/mock_client.h>
#include <infra/pod_agent/libs/system_logs_sender/mock_system_logs_sender.h>

#include <library/cpp/yson/node/node_io.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

#include <util/system/thread.h>

namespace NInfra::NPodAgent::NTreeGeneratorTest {

static TLogger logger({});

class ITestTreeGeneratorCanon {
public:
    ITestTreeGeneratorCanon(const bool isBoxAgentMode = false)
        : Ticker_(new TMtpPeriodTicker(TBehaviorTickerConfig{}, logger.SpawnFrame(), logger.SpawnFrame()))
        , UpdateHolder_(new TUpdateHolder())
        , BoxStatusRepository_(new TBoxStatusRepository())
        , LayerStatusRepository_(new TLayerStatusRepository())
        , StaticResourceStatusRepository_(new TStaticResourceStatusRepository())
        , VolumeStatusRepository_(new TVolumeStatusRepository())
        , WorkloadStatusRepository_(new TWorkloadStatusRepository())
        , WorkloadStatusRepositoryInternal_(new TWorkloadStatusRepositoryInternal())
        , PathHolder_(
            new TPathHolder(
                "/"
                , {{"", ""}, {"virtual_disk", "///place"}}
                , {{"", "/"}, {"///place", "/"}}
                , "/"
                , "test_storage_"
                , "Pod_Agent_test_" + ToString(TThread::CurrentThreadId()) + "_"
                , ""
                , ""
                , "rbind_volumes"
            )
        )
    {
        Holder_ = new TStatusRepository(
            UpdateHolder_
            , BoxStatusRepository_
            , LayerStatusRepository_
            , StaticResourceStatusRepository_
            , VolumeStatusRepository_
            , WorkloadStatusRepository_
        );
        StatusNTickerHolder_ = new TStatusNTickerHolder(
            Ticker_
            , Holder_
            , WorkloadStatusRepositoryInternal_
            , new TMockSystemLogsSender()
            , new TMockSystemLogsSender()
            , isBoxAgentMode
        );
    }

    void DoTest() {
        Ticker_->Start();
        SetupTest();
        CreateWorker();
        Test();
        Ticker_->Stop();
    }

protected:
    virtual void CreateWorker() = 0;
    virtual void Test() = 0;

    virtual void SetupTest() { // override for specific setup
        // do nothing
    }

protected:
    TMtpPeriodTickerPtr Ticker_;
    TUpdateHolderPtr UpdateHolder_;

    TBoxStatusRepositoryPtr BoxStatusRepository_;
    TLayerStatusRepositoryPtr LayerStatusRepository_;
    TStaticResourceStatusRepositoryPtr StaticResourceStatusRepository_;
    TVolumeStatusRepositoryPtr VolumeStatusRepository_;
    TWorkloadStatusRepositoryPtr WorkloadStatusRepository_;

    TWorkloadStatusRepositoryInternalPtr WorkloadStatusRepositoryInternal_;

    TStatusRepositoryPtr Holder_;
    TStatusNTickerHolderPtr StatusNTickerHolder_;
    TPathHolderPtr PathHolder_;
};

} // NInfra::NPodAgent::NTreeGeneratorTest
