#include "test_functions.h"

namespace NInfra::NPodAgent::NTreeGeneratorTest {

TBehavior3 GetTestTemplateTree(const TMap<TString, TString>& properties, const TString& rootName, const TString& rootTitle) {
    TBehavior3 templateTree;
    templateTree.set_title("A behavior tree");
    templateTree.set_root("1");

    TBehavior3Node root;
    root.set_id("1");
    root.set_name(rootName);
    if (!rootTitle.empty()) {
        root.set_title(rootTitle);
    }

    google::protobuf::Value val;
    for (auto& property : properties) {
        val.set_string_value(property.second);
        (*root.mutable_properties())[property.first] = val;
    }

    (*templateTree.mutable_nodes())["1"] = root;

    return templateTree;
}

} // namespace NInfra::NPodAgent::NTreeGeneratorTest
