#pragma once

#include "layer_tree_generator.h"
#include "static_resource_tree_generator.h"
#include "volume_tree_generator.h"
#include "box_tree_generator.h"
#include "workload_tree_generator.h"

#include <infra/pod_agent/libs/system_logs_sender/system_logs_sender.h>

namespace NInfra::NPodAgent {

class TTreesGenerator {
public:
    TTreesGenerator(
        TLogger& logger
        , const TCacheConfig& cacheConfig
        , const TLogsTransmitterConfig& logsTransmitterConfig
        , const TResourcesConfig& resourcesConfig
        , const TString& hostname
        , const TString& ytPath
        , const TString& baseSearchPath
        , const TString& publicVolumePath
        , const TString& publicVolumeMountPath
        , const TString& podAgentBinaryFileName
        , const TString& networkDevice
        , bool isPossibleToTransmitSystemLogs
        , TAsyncIpClientPtr asyncIpClient
        , TAsyncPortoClientPtr asyncNestedPorto
        , TNetworkClientPtr networkClient
        , TPathHolderPtr pathHolder
        , TPosixWorkerPtr posixWorker
        , TStatusNTickerHolderPtr statusNTickerHolder
        , TTemplateBTStoragePtr templateBTStorage
        , const bool isBoxAgentMode = false
    );

    API::TPodAgentStatus UpdatePodAgentRequest(const API::TPodAgentRequest& podAgentRequest, TLogFramePtr logFrame);

    API::TPodAgentStatus GetStatus(bool conditionsOnly);

public:
    static bool GetTransmitSystemLogs(const API::TPodAgentSpec& podAgentSpec, bool isPossibleToTransmitSystemLogs);

private:
    static constexpr const char* COUNTER_NON_INCREMENTED_SPEC_TIMESTAMP_ERRORS = "pod_agent_non_incremented_spec_timestamp_errors";

    THolder<TStaticResourceTreeGenerator> StaticResourceTreeGenerator_;
    THolder<TLayerTreeGenerator> LayerTreeGenerator_;
    THolder<TVolumeTreeGenerator> VolumeTreeGenerator_;
    THolder<TBoxTreeGenerator> BoxTreeGenerator_;
    THolder<TWorkloadTreeGenerator> WorkloadTreeGenerator_;

    TStatusNTickerHolderPtr StatusNTickerHolder_;

    API::TPodAgentRequest Request_;

    bool IsPossibleToTransmitSystemLogs_;
    const bool IsBoxAgentMode_;
};

} // namespace NInfra::NPodAgent
