#pragma once

#include "layer_tree_generator.h"
#include "static_resource_tree_generator.h"

#include <infra/pod_agent/libs/behaviour/template_bt_storage/template_bt_storage.h>
#include <infra/pod_agent/libs/path_util/path_holder.h>
#include <infra/pod_agent/libs/pod_agent/status_and_ticker_holder/status_and_ticker_holder.h>
#include <infra/pod_agent/libs/porto_client/async_client.h>
#include <infra/pod_agent/libs/posix_worker/posix_worker.h>

namespace NInfra::NPodAgent {

/**
    Creates behavior tree for each new volume from provided TreeTemplate
    Removes unneeded trees
    Ticks trees via TMtpPeriodTicker
    Method Wait() waits for signal from Shutdown() and waits the TMtpPeriodTicker
    Method Stop() calls {Shutdown(); Wait();}
*/
class TVolumeTreeGenerator {
public:
    TVolumeTreeGenerator(
        TLogger& logger
        , TPathHolderPtr pathHolder
        , const TBehavior3& volumeTreeTemplate
        , TAsyncPortoClientPtr porto
        , TPosixWorkerPtr posixWorker
        , TStatusNTickerHolderPtr statusNTickerHolder
        , TTemplateBTStoragePtr templateBTStorage
    )
        : Logger_(logger)
        , PathHolder_(pathHolder)
        , VolumeTreeTemplate_(volumeTreeTemplate)
        , Porto_(porto)
        , PosixWorker_(posixWorker)
        , StatusNTickerHolder_(statusNTickerHolder)
        , TemplateBTStorage_(templateBTStorage)
    {}

    ~TVolumeTreeGenerator() {}

public:
    struct TVolumeToAdd {
        TUpdateHolder::TVolumeTarget Target_;
    };

    struct TVolumesToAdd {
        TMap<TString, TVolumeToAdd> Volumes_;
    };

public:
    TVolumeTreeGenerator::TVolumesToAdd UpdateSpec(
        const google::protobuf::RepeatedPtrField<API::TVolume>& volumes
        , API::EPodAgentTargetState podAgentTargetState
        , const TLayerTreeGenerator::TLayersToAdd& layers
        , const TStaticResourceTreeGenerator::TStaticResourcesToAdd& staticResources
        , ui64 specTimestamp
        , ui32 revision
    );

    void RemoveVolumes(const TVolumesToAdd& toAdd);
    void AddVolumes(const TVolumesToAdd& toAdd);

private:
    TVolumeToAdd GetVolumeToAdd(
        const API::TVolume& volume
        , const TLayerTreeGenerator::TLayersToAdd& layers
        , const TStaticResourceTreeGenerator::TStaticResourcesToAdd& staticResources
        , ui64 specTimestamp
        , ui32 revision
    ) const;

private:
    TLogger& Logger_;
    TPathHolderPtr PathHolder_;
    const TBehavior3 VolumeTreeTemplate_;

    TAsyncPortoClientPtr Porto_;
    TPosixWorkerPtr PosixWorker_;
    TStatusNTickerHolderPtr StatusNTickerHolder_;
    TTemplateBTStoragePtr TemplateBTStorage_;
};

} // namespace NInfra::NPodAgent
