#pragma once

#include <infra/libs/logger/logger.h>
#include <infra/pod_agent/libs/pod_agent/period_job_worker/period_job.h>
#include <infra/pod_agent/libs/pod_agent/status_and_ticker_holder/status_and_ticker_holder.h>
#include <infra/pod_agent/libs/system_logs_sender/statistics/system_logs_statistics_printer.h>

namespace NInfra::NPodAgent {

class TTreesUpdateJob;
using TTreesUpdateJobPtr = TIntrusivePtr<TTreesUpdateJob>;

/**
    Looks at StatusRepository for object ids
    Then Looks at TargetTree and change object tree if some conditions satisfied
        1. For resources: NOT IMPLEMENTED
        2. For volumes: NOT IMPLEMENTED
        3. For boxes: NOT IMPLEMENTED
        4. For workloads: Workload in REMOVED State
*/
class TTreesUpdateJob : public IPeriodJob {
public:
    TTreesUpdateJob(
        const TDuration& period
        , TLogFramePtr logFrame
        , TLogFramePtr periodWorkerEventsLogFrame
        , TStatusNTickerHolderPtr statusNTickerHolder
        , TSystemLogsStatisticsPrinterPtr systemLogsStatisticsPrinter
        , TMutex& updateSpecMutex
    )
        : IPeriodJob("TreesUpdateJob", period, periodWorkerEventsLogFrame)
        , LogFrame_(logFrame)
        , StatusNTickerHolder_(statusNTickerHolder)
        , SystemLogsStatisticsPrinter_(systemLogsStatisticsPrinter)
        , UpdateSpecMutex_(updateSpecMutex)
    {}

    virtual void Run() override;

private:
    void UpdateStaticResourceTrees();
    void UpdateLayerTrees();
    void UpdateVolumeTrees();
    void UpdateBoxTrees();
    void UpdateWorkloadTrees();

    static NLogEvent::TTreesUpdateJobUpdateTree::EUpdateResult ConvertUpdateResult(TStatusNTickerHolder::TUpdateObjectResult::EUpdateResult updateResult);

private:
    TLogFramePtr LogFrame_;
    TStatusNTickerHolderPtr StatusNTickerHolder_;
    TSystemLogsStatisticsPrinterPtr SystemLogsStatisticsPrinter_;

    const TMutex& UpdateSpecMutex_;
};

} // namespace NInfra::NPodAgent
