#include "update_holder.h"

#include <infra/pod_agent/libs/pod_agent/update_holder/test_lib/test_functions.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

namespace NInfra::NPodAgent::NUpdateHolderTest  {

Y_UNIT_TEST_SUITE(TUpdateHolderTestSuite) {

Y_UNIT_TEST(TestBoxTarget) {
    TUpdateHolderPtr updateHolder = new TUpdateHolder();

    const TString id = "my_box";

    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->BoxHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->BoxHasTargetRemove(id));

    updateHolder->SetBoxTarget(TUpdateHolder::TBoxTarget::GetTargetRemove(id));
    updateHolder->SetBoxTarget(NObjectTargetTestLib::CreateBoxTargetSimple(id, "hash1", 1, 1));
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->BoxHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->BoxHasTargetRemove(id));

    TUpdateHolder::TBoxTarget secondTarget = NObjectTargetTestLib::CreateBoxTargetSimple(id, "hash2", 2, 2);
    updateHolder->SetBoxTarget(secondTarget);
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->BoxHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->BoxHasTargetRemove(id));

    TUpdateHolder::TBoxTarget target = updateHolder->GetAndRemoveBoxTarget(id);
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->BoxHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->BoxHasTargetRemove(id));
    UNIT_ASSERT_EQUAL(target, secondTarget);

    TUpdateHolder::TBoxTarget emptyTarget = updateHolder->GetAndRemoveBoxTarget(id);
    UNIT_ASSERT_EQUAL(emptyTarget, TUpdateHolder::TBoxTarget::GetEmptyTarget());

    updateHolder->SetBoxTarget(TUpdateHolder::TBoxTarget::GetTargetRemove(id));
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->BoxHasTarget(id));
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->BoxHasTargetRemove(id));

    TUpdateHolder::TBoxTarget removeTarget = updateHolder->GetAndRemoveBoxTarget(id);
    UNIT_ASSERT_EQUAL(removeTarget, TUpdateHolder::TBoxTarget::GetTargetRemove(id));
}

Y_UNIT_TEST(TestLayerTarget) {
    TUpdateHolderPtr updateHolder = new TUpdateHolder();

    const TString id = "my_layer";

    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->LayerHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->LayerHasTargetRemove(id));

    updateHolder->SetLayerTarget(TUpdateHolder::TLayerTarget::GetTargetRemove(id));
    updateHolder->SetLayerTarget(NObjectTargetTestLib::CreateLayerTargetSimple(id, "hash1", 1, 1));
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->LayerHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->LayerHasTargetRemove(id));

    TUpdateHolder::TLayerTarget secondTarget = NObjectTargetTestLib::CreateLayerTargetSimple(id, "hash2", 2, 2);
    updateHolder->SetLayerTarget(secondTarget);
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->LayerHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->LayerHasTargetRemove(id));

    TUpdateHolder::TLayerTarget target = updateHolder->GetAndRemoveLayerTarget(id);
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->LayerHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->LayerHasTargetRemove(id));
    UNIT_ASSERT_EQUAL(target, secondTarget);

    TUpdateHolder::TLayerTarget emptyTarget = updateHolder->GetAndRemoveLayerTarget(id);
    UNIT_ASSERT_EQUAL(emptyTarget, TUpdateHolder::TLayerTarget::GetEmptyTarget());

    updateHolder->SetLayerTarget(TUpdateHolder::TLayerTarget::GetTargetRemove(id));
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->LayerHasTarget(id));
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->LayerHasTargetRemove(id));

    TUpdateHolder::TLayerTarget removeTarget = updateHolder->GetAndRemoveLayerTarget(id);
    UNIT_ASSERT_EQUAL(removeTarget, TUpdateHolder::TLayerTarget::GetTargetRemove(id));
}

Y_UNIT_TEST(TestStaticResourceTarget) {
    TUpdateHolderPtr updateHolder = new TUpdateHolder();

    const TString id = "my_static_resource";

    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->StaticResourceHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->StaticResourceHasTargetRemove(id));

    updateHolder->SetStaticResourceTarget(TUpdateHolder::TStaticResourceTarget::GetTargetRemove(id));
    updateHolder->SetStaticResourceTarget(NObjectTargetTestLib::CreateStaticResourceTargetSimple(id, "hash1", 1, 1));
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->StaticResourceHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->StaticResourceHasTargetRemove(id));

    TUpdateHolder::TStaticResourceTarget secondTarget = NObjectTargetTestLib::CreateStaticResourceTargetSimple(id, "hash2", 2, 2);
    updateHolder->SetStaticResourceTarget(secondTarget);
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->StaticResourceHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->StaticResourceHasTargetRemove(id));

    TUpdateHolder::TStaticResourceTarget target = updateHolder->GetAndRemoveStaticResourceTarget(id);
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->StaticResourceHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->StaticResourceHasTargetRemove(id));
    UNIT_ASSERT_EQUAL(target, secondTarget);

    TUpdateHolder::TStaticResourceTarget emptyTarget = updateHolder->GetAndRemoveStaticResourceTarget(id);
    UNIT_ASSERT_EQUAL(emptyTarget, TUpdateHolder::TStaticResourceTarget::GetEmptyTarget());

    updateHolder->SetStaticResourceTarget(TUpdateHolder::TStaticResourceTarget::GetTargetRemove(id));
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->StaticResourceHasTarget(id));
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->StaticResourceHasTargetRemove(id));

    TUpdateHolder::TStaticResourceTarget removeTarget = updateHolder->GetAndRemoveStaticResourceTarget(id);
    UNIT_ASSERT_EQUAL(removeTarget, TUpdateHolder::TStaticResourceTarget::GetTargetRemove(id));
}

Y_UNIT_TEST(TestVolumeTarget) {
    TUpdateHolderPtr updateHolder = new TUpdateHolder();

    const TString id = "my_volume";

    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->VolumeHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->VolumeHasTargetRemove(id));

    updateHolder->SetVolumeTarget(TUpdateHolder::TVolumeTarget::GetTargetRemove(id));
    updateHolder->SetVolumeTarget(NObjectTargetTestLib::CreatePersistentVolumeTargetSimple(id, "hash1", 1, 1));
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->VolumeHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->VolumeHasTargetRemove(id));

    TUpdateHolder::TVolumeTarget secondTarget = NObjectTargetTestLib::CreatePersistentVolumeTargetSimple(id, "hash2", 2, 2);
    updateHolder->SetVolumeTarget(secondTarget);
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->VolumeHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->VolumeHasTargetRemove(id));

    TUpdateHolder::TVolumeTarget target = updateHolder->GetAndRemoveVolumeTarget(id);
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->VolumeHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->VolumeHasTargetRemove(id));
    UNIT_ASSERT_EQUAL(target, secondTarget);

    TUpdateHolder::TVolumeTarget emptyTarget = updateHolder->GetAndRemoveVolumeTarget(id);
    UNIT_ASSERT_EQUAL(emptyTarget, TUpdateHolder::TVolumeTarget::GetEmptyTarget());

    updateHolder->SetVolumeTarget(TUpdateHolder::TVolumeTarget::GetTargetRemove(id));
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->VolumeHasTarget(id));
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->VolumeHasTargetRemove(id));

    TUpdateHolder::TVolumeTarget removeTarget = updateHolder->GetAndRemoveVolumeTarget(id);
    UNIT_ASSERT_EQUAL(removeTarget, TUpdateHolder::TVolumeTarget::GetTargetRemove(id));
}

Y_UNIT_TEST(TestWorkloadTarget) {
    TUpdateHolderPtr updateHolder = new TUpdateHolder();

    const TString id = "my_workload";

    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->WorkloadHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->WorkloadHasTargetRemove(id));

    updateHolder->SetWorkloadTarget(TUpdateHolder::TWorkloadTarget::GetTargetRemove(id));
    updateHolder->SetWorkloadTarget(NObjectTargetTestLib::CreateWorkloadTargetSimple(id, "hash1", 1, 1));
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->WorkloadHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->WorkloadHasTargetRemove(id));

    TUpdateHolder::TWorkloadTarget secondTarget = NObjectTargetTestLib::CreateWorkloadTargetSimple(id, "hash2", 2, 2);
    updateHolder->SetWorkloadTarget(secondTarget);
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->WorkloadHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->WorkloadHasTargetRemove(id));

    TUpdateHolder::TWorkloadTarget target = updateHolder->GetAndRemoveWorkloadTarget(id);
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->WorkloadHasTarget(id));
    UNIT_ASSERT(!updateHolder->GetUpdateHolderTarget()->WorkloadHasTargetRemove(id));
    UNIT_ASSERT_EQUAL(target, secondTarget);

    TUpdateHolder::TWorkloadTarget emptyTarget = updateHolder->GetAndRemoveWorkloadTarget(id);
    UNIT_ASSERT_EQUAL(emptyTarget, TUpdateHolder::TWorkloadTarget::GetEmptyTarget());

    updateHolder->SetWorkloadTarget(TUpdateHolder::TWorkloadTarget::GetTargetRemove(id));
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->WorkloadHasTarget(id));
    UNIT_ASSERT(updateHolder->GetUpdateHolderTarget()->WorkloadHasTargetRemove(id));

    TUpdateHolder::TWorkloadTarget removeTarget = updateHolder->GetAndRemoveWorkloadTarget(id);
    UNIT_ASSERT_EQUAL(removeTarget, TUpdateHolder::TWorkloadTarget::GetTargetRemove(id));
}

}

} // namespace NInfra::NPodAgent::NNUpdateHolderTest
