#include "async_client.h"
#include "nested_client.h"
#include "test_functions.h"

#include <infra/pod_agent/libs/porto_client/porto_test_lib/test_functions.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/system/thread.h>

namespace NInfra::NPodAgent::NPortoTest {

Y_UNIT_TEST_SUITE(AsyncPortoClient) {

Y_UNIT_TEST(AsyncPortoClientCreateContainer) {
    TPortoClientPtr rootClient = NPortoTestLib::GetSimplePortoClient();
    TLocalContainer rootContainer(rootClient, GetTestPrefix() + "AsyncPortoClient");
    TPortoClientPtr nestedClient = new TNestedPortoClient(rootClient, rootContainer);
    TPortoContainerName container("test");
    TAtomicSharedPtr<IThreadPool> mtpQueue = new TFakeThreadPool();

    {
        TAsyncPortoClientPtr asyncClient = new TAsyncPortoClient(nestedClient, mtpQueue);
        asyncClient->Create(container).GetValueSync().Success();

        TVector<TPortoContainerName> list = asyncClient->List().GetValueSync().Success();
        UNIT_ASSERT_EQUAL_C(list.size(), 1, "expected one container at list, got " << list.size());
        UNIT_ASSERT_C(list[0] == container, "container not found");

        auto res = asyncClient->Get({container}, {EPortoContainerProperty::State}).GetValueSync().Success();
        auto* ptr = res.FindPtr(container);
        UNIT_ASSERT_C(ptr, "container " << TString(container) << " not found");
        auto* valPtr = ptr->FindPtr(EPortoContainerProperty::State);
        UNIT_ASSERT_C(valPtr, "property " << EPortoContainerProperty::State << " not found");
        UNIT_ASSERT_EQUAL_C( valPtr->value(), ToString(EPortoContainerState::Stopped), "unexpected container state");
    }

    {
        TVector<TPortoContainerName> list = rootClient->List().Success();
        bool found = false;
        for (auto& it : list) {
            found |= (it == TPortoContainerName(rootContainer, container));
        }
        UNIT_ASSERT_C(found, "container not found");
    }
}

}

} // namespace NInfra::NPodAgent::NPortoTest
