#include "client.h"

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestClient {

Y_UNIT_TEST_SUITE(PortoContainerName) {

Y_UNIT_TEST(EscapeString) {
    {
        TString str = "MyContainerName";
        TPortoContainerName container(str);
        UNIT_ASSERT_EQUAL_C(TString(container), str, "'" << TString(container) << "'!='" << str << "'");
    }
    {
        TString str = "my_playlist (@chegoryu):";
        TString ans = "my_playlist0x200x28@chegoryu0x29:";
        TPortoContainerName container(str);
        UNIT_ASSERT_EQUAL_C(TString(container), ans, "'" << TString(container) << "'!='" << ans << "'");
    }
    {
        TString str = "Silver: Wham Bam Shang-A-Lang";
        TString ans = "Silver:0x20Wham0x20Bam0x20Shang-A-Lang";
        TPortoContainerName container(str);
        UNIT_ASSERT_EQUAL_C(TString(container), ans, "'" << TString(container) << "'!='" << ans << "'");
    }
    {
        TString str = "Rockwell: Somebody's Watching Me";
        TString ans = "Rockwell:0x20Somebody0x27s0x20Watching0x20Me";
        TPortoContainerName container(str);
        UNIT_ASSERT_EQUAL_C(TString(container), ans, "'" << TString(container) << "'!='" << ans << "'");
    }
    {
        TString str = "James Brown: It's A Man's, Man's, Man's World (Single Version (Mono))";
        TString ans = "James0x20Brown:0x20It0x27s0x20A0x20Man0x27s0x2c0x20Man0x27s0x2c0x20Man0x27s0x20World0x200x28Single0x20Version0x200x28Mono0x290x29";
        TPortoContainerName container(str);
        UNIT_ASSERT_EQUAL_C(TString(container), ans, "'" << TString(container) << "'!='" << ans << "'");
    }
    {
        TString str = ",...,";
        TString ans = "0x2c...0x2c";
        TPortoContainerName container(str);
        UNIT_ASSERT_EQUAL_C(TString(container), ans, "'" << TString(container) << "'!='" << ans << "'");
    }
}

Y_UNIT_TEST(EmbeddedContainer) {
    TPortoContainerName root("root");
    TPortoContainerName child("child");
    TPortoContainerName leaf(child, "leaf");
    TPortoContainerName result(root, leaf);
    TString ans = "root/child/leaf";
    UNIT_ASSERT_EQUAL_C(TString(result), ans, "'" << TString(result) << "'!='" << ans << "'");
}

}

} // namespace NInfra::NPodAgent::NTestClient
