#pragma once

#include "client.h"

namespace NInfra::NPodAgent {

class TMockPortoClient: public IPortoClient {
public:
    TMockPortoClient() {}

    TPortoClientPtr SwitchLogFrame(TLogFramePtr) override {
        // TMockPortoClient shouldn't have any data
        // So no need to copy it
        return const_cast<TMockPortoClient*>(this);
    }

    TExpected<void, TPortoError> Create(const TPortoContainerName&) override { return TExpected<void, TPortoError>::DefaultSuccess(); }
    TExpected<void, TPortoError> CreateRecursive(const TPortoContainerName&) override {return TExpected<void, TPortoError>::DefaultSuccess(); }
    TExpected<void, TPortoError> Destroy(const TPortoContainerName&) override { return TExpected<void, TPortoError>::DefaultSuccess(); }
    TExpected<int, TPortoError> IsContainerExists(const TPortoContainerName&) override {return TExpected<int, TPortoError>::DefaultSuccess(); }

    TExpected<void, TPortoError> Start(const TPortoContainerName&) override { return TExpected<void, TPortoError>::DefaultSuccess(); }
    TExpected<void, TPortoError> Stop(const TPortoContainerName&, TDuration) override { return TExpected<void, TPortoError>::DefaultSuccess(); }
    TExpected<void, TPortoError> Kill(const TPortoContainerName&, int) override { return TExpected<void, TPortoError>::DefaultSuccess(); }
    TExpected<void, TPortoError> Pause(const TPortoContainerName&) override { return TExpected<void, TPortoError>::DefaultSuccess(); }
    TExpected<void, TPortoError> Resume(const TPortoContainerName&) override { return TExpected<void, TPortoError>::DefaultSuccess(); }

    TExpected<TString, TPortoError> WaitContainers(const TVector<TPortoContainerName>&, TDuration) override { return TExpected<TString, TPortoError>::DefaultSuccess(); }

    TExpected<TVector<TPortoContainerName>, TPortoError> List(const TString&) override { return TExpected<TVector<TPortoContainerName>, TPortoError>::DefaultSuccess(); }

    TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError> Get(const TVector<TPortoContainerName>&, const TVector<EPortoContainerProperty>&) override {
        return TExpected<TMap<TPortoContainerName, TMap<EPortoContainerProperty, TPortoGetResponse>>, TPortoError>::DefaultSuccess();
    }

    TExpected<TString, TPortoError> GetProperty(const TPortoContainerName&, EPortoContainerProperty, int) override { return TExpected<TString, TPortoError>::DefaultSuccess(); }
    TExpected<void, TPortoError> SetProperty(const TPortoContainerName&, EPortoContainerProperty, const TString&) override { return TExpected<void, TPortoError>::DefaultSuccess(); }
    TExpected<void, TPortoError> SetProperties(const TPortoContainerName&, const TMap<EPortoContainerProperty, TString>&) override { return TExpected<void, TPortoError>::DefaultSuccess(); }

    TExpected<TString, TPortoError> GetStdout(const TPortoContainerName&, int, int, int) override { return TExpected<TString, TPortoError>::DefaultSuccess(); }

    TExpected<TString, TPortoError> GetStderr(const TPortoContainerName&, int, int, int) override { return TExpected<TString, TPortoError>::DefaultSuccess(); }

    TExpected<TString, TPortoError> GetStream(const TPortoContainerName&, const TString&, int, int, int) override { return TExpected<TString, TPortoError>::DefaultSuccess(); }

    TExpected <TString, TPortoError> CreateVolume(
        const TString&
        , const TString&
        , const TString&
        , const TVector<TString>&
        , unsigned long long
        , const TString&
        , const EPortoVolumeBackend
        , const TPortoContainerName&
        , const TVector<TPortoVolumeShare>&
        , bool
    ) override { return TExpected<TString, TPortoError>::DefaultSuccess(); }
    TExpected<void, TPortoError> LinkVolume(const TString&, const TPortoContainerName&, const TString&, bool, bool) override { return TExpected<void, TPortoError>::DefaultSuccess(); }
    TExpected<void, TPortoError> UnlinkVolume(const TString&, const TPortoContainerName&, const TString&, bool) override { return TExpected<void, TPortoError>::DefaultSuccess(); }
    TExpected<TVector<TPortoVolume>, TPortoError> ListVolumes(const TString&, const TPortoContainerName&) override { return TExpected<TVector<TPortoVolume>, TPortoError>::DefaultSuccess(); }
    TExpected<TVector<TString>, TPortoError> ListVolumesPaths(const TString&, const TPortoContainerName&) override { return TExpected<TVector<TString>, TPortoError>::DefaultSuccess(); }
    TExpected<int, TPortoError> IsVolumeExists(const TString&) override { return TExpected<int, TPortoError>::DefaultSuccess(); };

    TExpected<void, TPortoError> ImportLayer(const TString&, const TString&, bool, const TString&, const TString&) override { return TExpected<void, TPortoError>::DefaultSuccess(); }
    TExpected<void, TPortoError> RemoveLayer(const TString&, const TString&) override { return TExpected<void, TPortoError>::DefaultSuccess(); }
    TExpected<TVector<TPortoLayer>, TPortoError> ListLayers(const TString&, const TString&) override { return TExpected<TVector<TPortoLayer>, TPortoError>::DefaultSuccess(); }

    TExpected<TString, TPortoError> GetLayerPrivate(const TString&, const TString&) override { return TExpected<TString, TPortoError>::DefaultSuccess(); }
    TExpected<void, TPortoError> SetLayerPrivate(const TString&, const TString&, const TString&) override { return TExpected<void, TPortoError>::DefaultSuccess(); }

    TExpected<TVector<TPortoStorage>, TPortoError> ListStorages(const TString&, const TString&) override { return TExpected<TVector<TPortoStorage>, TPortoError>::DefaultSuccess(); }
    TExpected<TString, TPortoError> GetStoragePrivate(const TString&, const TString&) override { return TExpected<TString, TPortoError>::DefaultSuccess(); };
    TExpected<void, TPortoError> RemoveStorage(const TString&, const TString&) override { return TExpected<void, TPortoError>::DefaultSuccess(); }
    TExpected<void, TPortoError> ImportStorage(const TString&, const TString&, const TString&, const TString&, const TString&) override { return TExpected<void, TPortoError>::DefaultSuccess(); }
    TExpected<bool, TPortoError> IsStorageExists(const TString&, const TString&) override { return TExpected<bool, TPortoError>::DefaultSuccess(); }
};

} // namespace NInfra::NPodAgent
