#pragma once

#include "property.h"
#include "porto_types.h"

#include <infra/porto/api/libporto.hpp>
#include <util/string/vector.h>

namespace NInfra::NPodAgent::NPortoRequestResponseConverter  {

Porto::TVolumeSpec ConvertVolumeCreationRequest(
    const TString& path
    , const TString& storage
    , const TString& place
    , const TVector<TString>& layers
    , unsigned long long quotaBytes
    , const TString& privateValue
    , const EPortoVolumeBackend backend
    , const TPortoContainerName& containerName
    , const TVector<TPortoVolumeShare>& staticResources
    , bool readOnly
);

Porto::TGetVolumeRequest ConvertGetVolumeRequest(
    const TVector<TString>& paths
    , const TPortoContainerName& containerName = TPortoContainerName::NoEscape("")
);

TString ConvertVolumeCreationResponse(const Porto::TVolumeSpec& response);

TExpected<void, TPortoError> ConvertContainerEnv(const TString& envStr, Porto::TContainerEnv* containerEnv, bool secret);

TExpected<Porto::TContainerSpec, TPortoError> ConvertPropertiesToProtoContainerSpec(const TPortoContainerName& containerName, const TMap<EPortoContainerProperty, TString>& properties);

} // namespace NInfra::NPodAgent::NPorotRequestResponseConverter
