#include "porto_types.h"

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestPortoTypes {

Y_UNIT_TEST_SUITE(TPortoErrorTExpectedSpecializationSuite) {

Y_UNIT_TEST(TestExceptionMessage) {
    TPortoError err;
    err.Code = EPortoError::Unknown;
    err.Action = "TestAction";
    err.Message = "Operation Failed";
    TExpected<int, TPortoError> res1(err);
    TExpected<void, TPortoError> res2(err);
    const TExpected<int, TPortoError> res3(err);
    const TExpected<void, TPortoError> res4(err);
    UNIT_ASSERT_EXCEPTION_CONTAINS(res1.Success(), yexception, "Error message: Unknown(1):TestAction::Operation Failed");
    UNIT_ASSERT_EXCEPTION_CONTAINS(res2.Success(), yexception, "Error message: Unknown(1):TestAction::Operation Failed");
    UNIT_ASSERT_EXCEPTION_CONTAINS(res3.Success(), yexception, "Error message: Unknown(1):TestAction::Operation Failed");
    UNIT_ASSERT_EXCEPTION_CONTAINS(res4.Success(), yexception, "Error message: Unknown(1):TestAction::Operation Failed");
}

}

} // namespace NInfra::NPodAgent::NTestPortoTypes
