#include "simple_client.h"
#include "test_functions.h"

#include <util/string/cast.h>
#include <util/system/thread.h>

namespace NInfra::NPodAgent::NPortoTest  {

TString GetTestPrefix() {
    return TStringBuilder() << "_CLIENT_TEST_" << ToString(TThread::CurrentThreadId()) << "_";
}

TPortoGetResponse CreateTPortoGetResponse(const TString& property, ui32 errorCode, const TString& errorMessage) {
    TPortoGetResponse result = TPortoGetResponse();
    result.set_value(property);
    result.set_error(Porto::EError(errorCode));
    result.set_errormsg(errorMessage);
    return result;
}

} // namespace NInfra::NPodAgent::NPortoTest

