#pragma once

#include <infra/libs/outcome/result.h>

#include <util/string/builder.h>

namespace NInfra::NPodAgent {

struct TPosixError {
    const i32 Errno;
    const TString Message;
};

using TPosixResult = TExpected<void, TPosixError>;
using TPosixCheckResult = TExpected<int, TPosixError>;
using TPosixStringVectorResult = TExpected<TVector<TString>, TPosixError>;
using TPosixStringResult = TExpected<TString, TPosixError>;
using TPosixTimeResult = TExpected<time_t, TPosixError>;
using TPosixTimeResultRecursive = TExpected<TList<time_t>, TPosixError>;

enum class EFileAccessMode: ui8 {
    Mode_UNMODIFIED      = 0  /* "unmodified" */,
    Mode_660             = 1  /* "660" */,
    Mode_600             = 2  /* "600" */
};

} // namespace NInfra::NPodAgent {

inline TString ToString(const NInfra::NPodAgent::TPosixError& error) {
    return TStringBuilder()
        << error.Errno
        << ':' << error.Message
    ;
}
