#pragma once

#include "infra/pod_agent/libs/push_client/utils/push_client_types.h"
#include "push_event.h"

#include <infra/libs/outcome/result.h>

#include <util/generic/ptr.h>

namespace NInfra::NPodAgent {

class IPushClient;
using TPushClientPtr = TIntrusivePtr<IPushClient>;

class IPushClient: public TAtomicRefCount<IPushClient> {
public:
    virtual TExpected<TSendLogResult, TPushClientError> Send(TPushEventConstPtr pushEvent) = 0;

    virtual ~IPushClient() = default;
};

} // namespace NInfra::NPodAgent
