#pragma once

#include <infra/pod_agent/libs/pod_agent/logs_transmitter/file_stream/file_stream_rotated.h>
#include <infra/pod_agent/libs/porto_client/porto_types.h>

namespace NInfra::NPodAgent {

class IPushEvent;

using TPushEventConstPtr = TIntrusiveConstPtr<IPushEvent>;

class IPushEvent: public TAtomicRefCount<IPushEvent> {
public:
    virtual TFileStreamRotatedPtr GetFileStream() const = 0;
    virtual ui64 GetOffsetToReadFrom() const = 0;
    virtual const TPortoContainerName& GetContainerName() const = 0;
    virtual const TPushContainer& GetPushContainer() const = 0;
    virtual ~IPushEvent() = default;
};

using TPushEvents = TVector<TPushEventConstPtr>;

} //namespace NInfra::NPodAgent
