#include "push_event_impl.h"

namespace NInfra::NPodAgent {

TPushEventImpl::TPushEventImpl(
    TFileStreamRotatedPtr fileStream
    , ui64 offsetToReadFrom
    , const TPushContainer& pushContainer
)
    : FileStream_(fileStream)
    , OffsetToReadFrom_(offsetToReadFrom)
    , PushContainer_(pushContainer)
{
}

TFileStreamRotatedPtr TPushEventImpl::GetFileStream() const {
    return FileStream_;
}

ui64 TPushEventImpl::GetOffsetToReadFrom() const {
    return OffsetToReadFrom_;
}

const TPortoContainerName& TPushEventImpl::GetContainerName() const {
    return PushContainer_.Container;
}

const TPushContainer& TPushEventImpl::GetPushContainer() const {
    return PushContainer_;
}

} //namespace NInfra::NPodAgent
