#pragma once

#include "push_event.h"

namespace NInfra::NPodAgent {

class TPushEventImpl: public IPushEvent {
public:
    TPushEventImpl(TFileStreamRotatedPtr fileStream, ui64 offsetToReadFrom, const TPushContainer& pushContainer);
    TFileStreamRotatedPtr GetFileStream() const override;
    ui64 GetOffsetToReadFrom() const override;
    const TPortoContainerName& GetContainerName() const override;
    const TPushContainer& GetPushContainer() const override;

private:
    TFileStreamRotatedPtr FileStream_;
    ui64 OffsetToReadFrom_;
    TPushContainer PushContainer_;
};

} //namespace NInfra::NPodAgent
