#pragma once

#include "push_event.h"

#include <infra/libs/outcome/result.h>
#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>

namespace NInfra::NPodAgent {

class IPushLogFormatter;
using TPushLogFormatterPtr = TIntrusivePtr<IPushLogFormatter>;

class IPushLogFormatter: public TAtomicRefCount<IPushLogFormatter> {
public:
    virtual TExpected<TFormattedLog, TPushClientError> Format(const TString& log, ui64 prevFormattedLogsSize = 0, ui64 prevFormattedRawLogsSize = 0) = 0;
    virtual ~IPushLogFormatter() = default;
};

} // namespace NInfra::NPodAgent
