#include "push_log_splitter.h"

#include <util/string/split.h>

namespace NInfra::NPodAgent {

TPushLogSplitter::TPushLogSplitter(ui64 maxFormattedLogSize, ui64 maxFormattedRawLogSize)
    : MaxFormattedLogSize_(maxFormattedLogSize)
    , MaxFormattedRawLogSize_(maxFormattedRawLogSize)
{}

TExpected<TFormattedLog, TPushClientError> TPushLogSplitter::Format(const TString& log, ui64 prevFormattedLogsSize, ui64 prevFormattedRawLogsSize) {
    if (log.empty()) {
        return TFormattedLog{};
    }

    TVector<TString> formattedLogData;

    TVector<TString> chunks;

    StringSplitter(log).Split(LOG_SPLITTER).Collect(&chunks);

    TString& lastLog = chunks.back();
    if (lastLog.size() <= MAX_LINE_SIZE_TO_GLUE) {
        lastLog = "";
    }

    ui64 numBytesBeforeWrapping = 0;
    ui64 numBytesAfterWrapping = 0;
    ui64 numRawBytesAfterWrapping = 0;

    ui32 numNotEmtyChunks = 0;

    for (ui64 chunkId = 0; chunkId < chunks.size(); ++chunkId) {
        TString chunk = chunks[chunkId];
        if (chunk.empty()) {
            numBytesBeforeWrapping += LOG_SPLITTER_SIZE;
            continue;
        }

        ++numNotEmtyChunks;
        if ((prevFormattedLogsSize + numBytesAfterWrapping + chunk.size() + NSessionMetaDescription::LOG_CHUNK_META_SIZE) > MaxFormattedLogSize_) {
            break;
        }

        if ((prevFormattedRawLogsSize + numRawBytesAfterWrapping + chunk.size()) > MaxFormattedRawLogSize_) {
            break;
        }

        formattedLogData.push_back(chunk);
        numBytesBeforeWrapping += chunk.size();

        numRawBytesAfterWrapping += chunk.size();
        numBytesAfterWrapping += chunk.size();
        numBytesAfterWrapping += NSessionMetaDescription::LOG_CHUNK_META_SIZE;
    }

    if (numNotEmtyChunks) {
        numBytesBeforeWrapping += (numNotEmtyChunks - 1) * LOG_SPLITTER_SIZE;
    } else {
        --numBytesBeforeWrapping;
    }

    return TFormattedLog{formattedLogData, numBytesBeforeWrapping};
}

} // namespace NInfra::NPodAgent

