#pragma once

#include "push_log_formatter.h"

namespace NInfra::NPodAgent {

class TPushLogSplitter: public IPushLogFormatter {
public:
    TPushLogSplitter(ui64 maxFormattedLogSize, ui64 maxFormattedRawLogSize);

    virtual TExpected<TFormattedLog, TPushClientError> Format(const TString& log, ui64 prevFormattedWithMetaLogsSize = 0, ui64 prevFormattedRawLogsSize = 0) override;

private:
    static constexpr const ui32 MAX_LINE_SIZE_TO_GLUE = 8192;
    static constexpr const ui32 LOG_SPLITTER_SIZE = 1;
    static constexpr const char LOG_SPLITTER = '\n';

private:
    const ui64 MaxFormattedLogSize_;
    const ui64 MaxFormattedRawLogSize_;
};

} // namespace NInfra::NPodAgent
