#pragma once

#include <infra/libs/outcome/result.h>
#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>

#include <util/digest/numeric.h>
#include <util/generic/ptr.h>
#include <util/generic/string.h>

namespace NInfra::NPodAgent {

class IPushSession;
using TPushSessionPtr = TIntrusivePtr<IPushSession>;

class IPushSession: public TAtomicRefCount<IPushSession> {
public:
    virtual const TString& GetId() const = 0;
    virtual ui64 GetSeqNumber() const = 0;
    virtual TExpected<void, TPushClientError> SendLog(const TVector<TString>& payload, ui64 timestampMs) = 0;
    virtual TExpected<void, TPushClientError> Activate(const TString& logName, const TString& sessionId) = 0;
    virtual bool IsActive() const = 0;
    virtual void Deactivate() = 0;
    virtual void IncreaseLogSeqNumber(ui32 increaseFactor) = 0;

    virtual ~IPushSession() = default;
};

} // namespace NInfra::NPodAgent
