#include "push_session_factory_impl.h"

#include "push_session_impl.h"

namespace NInfra::NPodAgent {

TPushSessionFactoryImpl::TPushSessionFactoryImpl(
    const ELogType& typeOfLog
    , TGrpcChannelPtr grpcChannel
    , const TString& staticSecret
)
    : TypeOfLog_(typeOfLog)
    , GrpcChannel_(grpcChannel)
    , StaticSecret_(staticSecret)
{
}

TPushSessionPtr TPushSessionFactoryImpl::Create(const TPushContainer& pushContainer) {
    return new TPushSessionImpl(GrpcChannel_, TypeOfLog_, pushContainer, StaticSecret_);
}

} // namespace NInfra::NPodAgent
