#pragma once

#include "push_session_factory.h"

namespace NInfra::NPodAgent {

class TPushSessionFactoryImpl;
using TPushSessionFactoryImplPtr = TIntrusivePtr<TPushSessionFactoryImpl>;

class TPushSessionFactoryImpl: public IPushSessionFactory {

public:
    TPushSessionFactoryImpl(
        const ELogType& typeOfLog
        , TGrpcChannelPtr grpcChannel
        , const TString& staticSecret
    );

    TPushSessionPtr Create(const TPushContainer& pushContainer) override;

private:
    const ELogType TypeOfLog_;
    TGrpcChannelPtr GrpcChannel_;
    const TString StaticSecret_;
};

} // namespace NInfra::NPodAgent
