#pragma once

#include "push_session.h"

namespace NInfra::NPodAgent {

class TPushSessionImpl;
using TPushSessionImplPtr = TIntrusivePtr<TPushSessionImpl>;

class TPushSessionImpl: public IPushSession {
public:
    TPushSessionImpl(
        TGrpcChannelPtr grpcChannel
        , const ELogType& typeOfLog
        , const TPushContainer& pushContainer
        , const TString& staticSecret
    );

    const TString& GetId() const override;
    ui64 GetSeqNumber() const override;
    TExpected<void, TPushClientError> SendLog(const TVector<TString>& payload, ui64 timestampMs) override;
    TExpected<void, TPushClientError> Activate(const TString& logName, const TString& sessionId) override;
    bool IsActive() const override;
    void Deactivate() override;
    void IncreaseLogSeqNumber(ui32 increaseFactor) override;

    bool operator==(const TPushSessionImpl& rhs) const {
        return this->Stream_ == rhs.Stream_
               && this->TypeOfLog_ == rhs.TypeOfLog_
               && this->Context_ == rhs.Context_
               && this->StaticSecret_ == rhs.StaticSecret_
               && this->SessionId_ == rhs.SessionId_
               && this->LogSeqNumber_ == rhs.LogSeqNumber_;
    }

private:
    static void AddMetaObject(TPushLogRequest& logRequest, const TString& key, const TString& value);

public:
    static constexpr const char* DEPLOY_BOX_KEY = "deploy_box";
    static constexpr const char* DEPLOY_WORKLOAD_KEY = "deploy_workload";
    static constexpr const char* DEPLOY_CONTAINER_ID_KEY = "deploy_container_id";
    static constexpr const char* DEPLOY_LOGGER_NAME_KEY = "deploy_logger_name";

private:
    static const ui64 START_LOG_SEQ_NUMBER = 1;

private:
    THolder<NUnifiedAgentProto::UnifiedAgentService::Stub> Stub_;
    TGrpcPushStreamPtr Stream_;
    TGrpcPushContextPtr Context_;
    const TString StaticSecret_;
    TString SessionId_;
    ui64 LogSeqNumber_;
    const ELogType TypeOfLog_;
    TPushContainer PushContainer_;
};

} // namespace NInfra::NPodAgent
