#pragma once

#include "push_session.h"

namespace NInfra::NPodAgent {

class TPushSessionMock: public IPushSession {
public:
    TPushSessionMock() = default;

    const TString& GetId() const override { return Id_; }
    ui64 GetSeqNumber() const override { return 0; }
    TExpected<void, TPushClientError> SendLog(const TVector<TString>&, ui64) override { return TExpected<void, TPushClientError>::DefaultSuccess(); }
    TExpected<void, TPushClientError> Activate(const TString&, const TString&) override { return TExpected<void, TPushClientError>::DefaultSuccess(); }
    bool IsActive() const override { return false; }
    void Deactivate() override { }
    void IncreaseLogSeqNumber(ui32) override { }

private:
    TString Id_;
};

} //namespace NInfra::NPodAgent
