#pragma once

#include "client.h"
#include "push_log_formatter.h"

#include <infra/pod_agent/libs/pod_agent/logs_transmitter/holders/session_holder_impl.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/statistics/logs_transmitter_statistics.h>

namespace NInfra::NPodAgent {

class TSimplePushClient;
using TSimplePushClientPtr = TIntrusivePtr<TSimplePushClient>;

class TSimplePushClient: public IPushClient {
public:
    TSimplePushClient(
        TPushLogFormatterPtr pushLogFormatter
        , TSessionHolderPtr sessionHolder
        , ui64 maxLogSizeToRead
        , TLogsTransmitterStatisticsPtr statistics
    );

    TExpected<TSendLogResult, TPushClientError> Send(TPushEventConstPtr pushEvent) override;

private:
    static ui32 FormattedLogWithMetaSizeBytes(const TVector<TString>& formattedLogData) {
         ui32 size = FormattedLogWithoutMetaSizeBytes(formattedLogData);
         size += formattedLogData.size()*NSessionMetaDescription::LOG_CHUNK_META_SIZE;
         return size;
    }

    static ui32 FormattedLogWithoutMetaSizeBytes(const TVector<TString>& formattedLogData) {
        ui32 size = 0;
        for (const auto& logSample: formattedLogData) {
            size += logSample.size();
        }

        return size;
    }

private:
    TExpected<TFormattedLog, TPushClientError> ReadAndFormatLogs(TPushEventConstPtr pushEvent);
    TExpected<TPushSessionPtr, TPushClientError> GetSession(const TPushContainer& pushContainer);

private:
    TPushLogFormatterPtr PushLogFormatter_;
    TSessionHolderPtr SessionHolder_;
    const ui64 MaxLogSizeToRead_;
    TLogsTransmitterStatisticsPtr Statistics_;
};

} // namespace NInfra::NPodAgent
