#pragma once

#include <contrib/libs/grpc/include/grpc++/grpc++.h>

#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>

namespace NInfra::NPodAgent {

class TUnifiedAgentModelMock : public NUnifiedAgentProto::UnifiedAgentService::Service {
public:
    TUnifiedAgentModelMock()
        : LastResponseNum_(0)
    {
    }

    grpc::Status Session(
        grpc::ServerContext*,
        grpc::ServerReaderWriter<TPushLogResponse, TPushLogRequest>* stream
    ) override {

        TPushLogRequest request;
        while(stream->Read(&request)) {
            Requests.push_back(request);

            TPushLogResponse response;
            if (LastResponseNum_ < Responses.size()) {
                response = Responses[LastResponseNum_];
                ++LastResponseNum_;
            }
            stream->Write(response);
        }

        return grpc::Status::OK;
    }

    void AddResponse(const TPushLogResponse& response) {
        Responses.push_back(response);
    }

    const TVector<TPushLogRequest>& GetRequests() {
        return Requests;
    }

private:
    ui32 LastResponseNum_;
    TVector<TPushLogRequest> Requests;
    TVector<TPushLogResponse> Responses;
};

class TUnifiedAgentMock {
public:
    TUnifiedAgentMock(TUnifiedAgentModelMock* model, ui16 port)
        : Model_(model)
        , Port_(port)
    {
    }

    void Start() {
        ServerBuilder_ = MakeHolder<grpc::ServerBuilder>();
        ServerBuilder_->AddListeningPort(TStringBuilder() << "localhost:" << Port_, grpc::InsecureServerCredentials());

        ServerBuilder_->RegisterService(Model_);

        std::unique_ptr<grpc::Server> server(ServerBuilder_->BuildAndStart());
        Server_.Reset(server.release());
    }

    void Stop() {
        Server_->Shutdown();
        Server_->Wait();
    }

    ~TUnifiedAgentMock() {
        try {
            Stop();
        } catch(...) {
        }
    }

private:
    TUnifiedAgentModelMock* Model_;
    ui16 Port_;
    THolder<grpc::ServerBuilder> ServerBuilder_;
    THolder<grpc::Server> Server_;
};

}
