#include "push_client_utils.h"

namespace NInfra::NPodAgent::NPushClientUtils  {

TExpected<TPushLogResponse, TPushClientError> MakeRequest(TGrpcPushStreamPtr stream, const TPushLogRequest& request) {
    TPushLogResponse response;

    try {
        if (!stream->Write(request)) {
            grpc::Status writeFinishStatus = stream->Finish();
            if (!writeFinishStatus.ok()) {
                return TPushClientError{EPushClientError::GrpcStreamBroken, TStringBuilder() << "grpc stream broken on write: " << writeFinishStatus.error_message()};
            }
        }

        if (!stream->Read(&response)) {
            grpc::Status readFinishStatus = stream->Finish();
            if (!readFinishStatus.ok()) {
                return TPushClientError{EPushClientError::GrpcStreamBroken, TStringBuilder() <<  "grpc stream broken on read: " << readFinishStatus.error_message()};
            }
        }

    } catch(...) {
        return TPushClientError{EPushClientError::ExceptionWhileStreamOperation, CurrentExceptionMessage()};
    }

    return response;
}

TExpected<TString, TPushClientError> ReadLog(TFileStreamRotatedPtr fileStream, ui64 offset, ui64 maxLogSizeToRead) {
    auto fileSize = OUTCOME_TRYX(fileStream->GetFileSize());

    if (fileSize < offset) {
        return TPushClientError{EPushClientError::InvalidPushLogEvent, TStringBuilder() << "Event offset is greater than file size. Path: " << fileStream->GetFilePath()};
    }

    if (fileSize == offset) {
        return TString("");
    }

    ui64 sizeToRead = fileSize - offset;

    TString log = OUTCOME_TRYX(fileStream->Read(offset, Min(sizeToRead, maxLogSizeToRead)));

    //if log is empty, we lost data
    if (log.Empty()) {
        return TPushClientError{EPushClientError::FileReadingError, TStringBuilder() << "Empty log was read. Path: " << fileStream->GetFilePath()};
    }

    return log;
}

} // namespace NInfra::NPodAgent::NPushClientTypesConverter
