#include "router_api.h"

#include <infra/libs/service_iface/str_iface.h>

namespace NInfra::NPodAgent {

TRequestRouterPtr CreateRouter(IApi& service, bool withPrivateAPI) {
    auto router = MakeSimpleShared<TRequestRouter<IApi>>(service);

    (*router)
        .Add<TEmptyRequest<TReqPing>, TRawDataReply<TRspPing>>("/ping", "Pong.", &IApi::Ping)
        .Add<TEmptyRequest<TReqPodStatusJson>, TRawDataReply<TRspPodStatusJson>>("/pod_status", "Get pod status", &IApi::PodStatusJson)
        .Add<TEmptyRequest<TReqPodAttributesJson>, TRawDataReply<TRspPodAttributesJson>>("/pod_attributes", "Get pod and boxes resources and labels.", &IApi::PodAttributesJson)
        .Add<TEmptyRequest<TReqVersion>, TRawDataReply<TRspVersion>>("/version", "Show agent version.", &IApi::Version)
        .Add<TJsonOrEmpty2ProtoRequest<TReqSensors, true>, TRawDataReply<TRspSensors>>("/sensors", "Show pod_agent infra sensors", &IApi::Sensors)
        .Add<TJsonOrEmpty2ProtoRequest<TReqSensors, true>, TRawDataReply<TRspSensors>>("/user_sensors", "Show pod_agent user sensors", &IApi::UserSensors)
    ;

    if (withPrivateAPI) {
        (*router)
            .Add<TEmptyRequest<TReqConfig>, TRawDataReply<TRspConfig>>("/config", "Show config.", &IApi::Config)
            .Add<TEmptyRequest<TReqReopenLog>, TEmptyReply<TRspReopenLog>>("/reopen_log", "Reopen eventlog.", &IApi::ReopenLog)
            .Add<TEmptyRequest<TReqShutdown>, TEmptyReply<TRspShutdown>>("/shutdown", "Shutdown agent.", &IApi::Shutdown)
            .Add<TJson2ProtoRequest<API::TPodAgentRequest, true>, TProto2JsonReply<API::TPodAgentStatus>>("/update_pod_request", "Update PodAgent spec from TPodAgentRequest.", &IApi::UpdatePodAgentRequest)
            .Add<TEmptyRequest<TReqGetPodAgentStatus>, TProto2JsonReply<API::TPodAgentStatus>>("/get_pod_agent_status", "Get PodAgent status.", &IApi::GetPodAgentStatus)
            .Add<TJson2ProtoRequest<TReqSetLogLevel>, TEmptyReply<TRspSetLogLevel>>("/set_log_level", "Set log level.", &IApi::SetLogLevel)
        ;
    }

    return router;
}

TRequestRouterPtr CreateRouter(IAliveApi& service) {
    auto router = MakeSimpleShared<TRequestRouter<IAliveApi>>(service);
    (*router)
        .Add<TEmptyRequest<API::TReqAlive>, TRawDataReply<API::TRspAlive>>("/alive", "Alive.", &IAliveApi::Alive)
    ;

    return router;
}

} // namespace NInfra::NPodAgent
