#include "alive_service.h"

#include <infra/pod_agent/libs/router_api/router_api.h>

namespace NInfra::NPodAgent {

THolder<TAliveService> TAliveService::MakeService(
    const TConfig& config
    , TLogger& stderrLogger
) {
    return THolder<TAliveService>(
        new TAliveService(
            config
            , stderrLogger
        )
    );
}

TAliveService::TAliveService(
    const TConfig& config
    , TLogger& stderrLogger
)
    : StderrLogger_(stderrLogger)
    , Config_(config)
{
}

void TAliveService::Alive(TRequestPtr<API::TReqAlive>, TReplyPtr<API::TRspAlive> reply) {
    API::TRspAlive rsp;
    *rsp.MutableData() = "ok";

    reply->Set(rsp);
}

void TAliveService::Start() {
    auto logFrame = StderrLogger_.SpawnFrame();

    if (Config_.HasHttpAliveService()) {
        HttpService_ = MakeHolder<THttpService>(Config_.GetHttpAliveService(), CreateRouter(*this));
        HttpService_->Start(logFrame);
    }
}

void TAliveService::Stop() {
    if (HttpService_) {
        auto logFrame = StderrLogger_.SpawnFrame();
        HttpService_->ShutDown();
        HttpService_->Wait(logFrame);
    }
}

} // namespace NInfra::NPodAgent
