#pragma once

#include <infra/pod_agent/libs/config/config.pb.h>
#include <infra/pod_agent/libs/service_iface/alive_service.h>
#include <infra/libs/http_service/service.h>

namespace NInfra::NPodAgent {


// Node agent gets pod agent alive status from this service.
// It is not possible to get alive status from TService Ping on pod agent start,
// because TService has variable time delay on creation for FS initialization
// DEPLOY-3985
class TAliveService: public IAliveService {
public:
    static THolder<TAliveService> MakeService(
        const TConfig& config
        , TLogger& stderrLogger
    );

    void Start() override;

    void Alive(TRequestPtr<API::TReqAlive>, TReplyPtr<API::TRspAlive> reply) override;

    void Stop() override;

private:
    TAliveService(
        const TConfig& config
        , TLogger& stderrLogger
    );

    // At this moment FS is not initialized (logdir not created)
    // so the only place where we can write log is stderr
    TLogger& StderrLogger_;
    const TConfig Config_;

    THolder<THttpService> HttpService_;
};

} // namespace NInfra::NPodAgent
