#pragma once

#include <infra/pod_agent/libs/grpc_service/service.h>
#include <infra/pod_agent/libs/multi_unistat/multi_unistat.h>
#include <infra/pod_agent/libs/pod_agent/core_service/core_service.h>
#include <infra/pod_agent/libs/porto_client/simple_client.h>
#include <infra/pod_agent/libs/service_iface/service.h>
#include <infra/libs/http_service/service.h>

namespace NInfra::NPodAgent {

class TService: public IService {
public:
    static THolder<TService> MakeService(
        const TString& selfBinaryFilePath
        , const TConfig& config
        , TLogger& stderrLogger
    );

    void Start() override;

    void Wait() override;

    void Shutdown(TRequestPtr<TReqShutdown>, TReplyPtr<TRspShutdown>) override;

    void Config(TRequestPtr<TReqConfig>, TReplyPtr<TRspConfig> reply) override;

    void Version(TRequestPtr<TReqVersion>, TReplyPtr<TRspVersion> reply) override;

    void Sensors(TRequestPtr<TReqSensors>, TReplyPtr<TRspSensors> reply) override;

    void UserSensors(TRequestPtr<TReqSensors>, TReplyPtr<TRspSensors> reply) override;

    void Ping(TRequestPtr<TReqPing>, TReplyPtr<TRspPing> reply) override;

    void SetLogLevel(TRequestPtr<TReqSetLogLevel>, TReplyPtr<TRspSetLogLevel> reply) override;

    void UpdatePodAgentRequest(TRequestPtr<API::TPodAgentRequest>, TReplyPtr<API::TPodAgentStatus> reply) override;

    void GetPodAgentStatus(TRequestPtr<TReqGetPodAgentStatus>, TReplyPtr<API::TPodAgentStatus> reply) override;

    void ReopenLog(TRequestPtr<TReqReopenLog>, TReplyPtr<TRspReopenLog> reply) override;

    void PodAttributesJson(TRequestPtr<TReqPodAttributesJson> request, TReplyPtr<TRspPodAttributesJson> reply) override;

    void PodStatusJson(TRequestPtr<TReqPodStatusJson> /*request*/, TReplyPtr<TRspPodStatusJson> reply) override;

private:
    TService(
        const TConfig& config
        , const TString& dom0PodRoot
        , const TMap<TString, TString>& virtualDisksToPlace
        , const TMap<TString, TString>& placesToDownloadVolumePath
    );

    void InitSignals();
    void InitVersionSignals();
    void InitStatusSignals();

    void IncCounter(const TString& name);
    void IncTotalCounter(const TString& name);
    void IncProcessedCounter(const TString& name);

    void LockSelfMemory();

    void CommonSensors(
        TMultiUnistat::ESignalNamespace signalNamespace
        ,TRequestPtr<TReqSensors> request
        , TReplyPtr<TRspSensors> reply
    );
    /*
        Create cache, public and resource download porto volumes
        Copy selfBinaryFilePath to public volume
        Fill virtualDisksToPlace with pairs <VirtualDiskIdRef, Place>
        Fill placesToDownloadVolumePath with pairs <Place, DownloadVolumePath>
    */
    static void InitPortoAndGetPlaces(
        const TString& selfBinaryFilePath
        , const TConfig& config
        , TString& dom0PodRoot
        , TMap<TString, TString>& virtualDisksToPlace
        , TMap<TString, TString>& placesToDownloadVolumePath
        , TLogger& stderrLogger
    );

    static void GetOrCreateVolumeAndStorage(
        const TString& volumePath
        , const TString& volumeStorage
        , const TString& volumePlace
        , TPortoClientPtr porto
        , const TString& volumeType
    );

    static void CreatePortoPlace(
        const TString& path
    );

    static void GetAndCreateVirtualDisksPlacesAndPaths(
        const TVirtualDisksConfig& virtualDisksConfig
        , const TString& downloadVolumePath
        , TMap<TString, TString>& virtualDisksToPlace
        , TMap<TString, TString>& placesToDownloadVolumePath
    );

private:
    static inline const TString CACHE_VOLUME_DESCRIPTION = "cache volume";
    static inline const TString PUBLIC_VOLUME_DESCRIPTION = "public volume";
    static inline const TString RESOURCES_VOLUME_DESCRIPTION = "resources download volume";

    static inline const TString RESOURCES_VOLUME_DEFAULT_PATH = "/default/";
    static inline const TString RESOURCES_VOLUME_SPECIFIC_PATH = "/specific/";
    static inline const TString RESOURCES_VOLUME_VIRTUAL_DISK_PREFIX = "virtual_disk_";
    static inline const TString RESOURCES_VOLUME_ALIAS_PREFIX = "alias_";

    static inline const TString SIGNAL_ALIVE_DAEMONS_NAME = "pod_agent_common_alive_daemons";
    static inline const TString SIGNAL_UPTIME_NAME = "pod_agent_common_uptime";
    static inline const TString SIGNAL_MEMORY_LOCK_FAIL_NAME = "pod_agent_common_memory_lock_fail";
    static inline const TString SIGNAL_LAST_SUCCESSFUL_POD_AGENT_REQUEST_LAG_NAME = "pod_agent_common_last_successful_pod_agent_request_lag_ms";

    static inline const TString SIGNAL_SVN_REVISION_NAME = "pod_agent_common_svn_revision";
    static inline const TString SIGNAL_BRANCH_NAME = "pod_agent_common_branch";

    static inline const TString COUNTER_PREFIX = "pod_agent_service_";
    static inline const TString COUNTER_PROCESSED_REQUESTS_SUFFIX = "_processed_requests";
    static inline const TString COUNTER_TOTAL_REQUESTS_SUFFIX = "_total_requests";

    TLogger Logger_;
    TLogger TreeTraceLogger_;
    TLogger LogsTransmitterJobWorkerEventsLogger_;
    const TConfig Config_;
    TCoreService CoreService_;
    TInstant StartTime_;
    TInstant LastSuccessfulPodAgentRequestTime_;

    THolder<THttpService> HttpService_;
    THolder<TGrpcService> GrpcService_;
};

} // namespace NInfra::NPodAgent
