#pragma once

#include <infra/pod_agent/libs/service_iface/protos/service.pb.h>

#include <infra/libs/service_iface/errors.h>
#include <infra/libs/service_iface/reply.h>
#include <infra/libs/service_iface/request.h>

namespace NInfra::NPodAgent {

class IApi {
public:
    virtual void Shutdown(TRequestPtr<TReqShutdown>, TReplyPtr<TRspShutdown>) {
        ythrow TNotImplementedError();
    }

    virtual void SetLogLevel(TRequestPtr<TReqSetLogLevel>, TReplyPtr<TRspSetLogLevel>) {
        ythrow TNotImplementedError();
    }

    virtual void Config(TRequestPtr<TReqConfig>, TReplyPtr<TRspConfig>) {
        ythrow TNotImplementedError();
    }

    virtual void Version(TRequestPtr<TReqVersion>, TReplyPtr<TRspVersion>) {
        ythrow TNotImplementedError();
    }

    virtual void Ping(TRequestPtr<TReqPing>, TReplyPtr<TRspPing>) {
        ythrow TNotImplementedError();
    }

    virtual void Sensors(TRequestPtr<TReqSensors>, TReplyPtr<TRspSensors>) {
        ythrow TNotImplementedError();
    }

    virtual void UserSensors(TRequestPtr<TReqSensors>, TReplyPtr<TRspSensors>) {
        ythrow TNotImplementedError();
    }

    virtual void UpdatePodAgentRequest(TRequestPtr<API::TPodAgentRequest>, TReplyPtr<API::TPodAgentStatus>) {
        ythrow TNotImplementedError();
    }

    virtual void GetPodAgentStatus(TRequestPtr<TReqGetPodAgentStatus>, TReplyPtr<API::TPodAgentStatus>) {
        ythrow TNotImplementedError();
    }

    virtual void ReopenLog(TRequestPtr<TReqReopenLog>, TReplyPtr<TRspReopenLog>) {
        ythrow TNotImplementedError();
    }

    virtual void PodStatusJson(TRequestPtr<TReqPodStatusJson>, TReplyPtr<TRspPodStatusJson>) {
        ythrow TNotImplementedError();
    }

    virtual void PodAttributesJson(TRequestPtr<TReqPodAttributesJson>, TReplyPtr<TRspPodAttributesJson>) {
        ythrow TNotImplementedError();
    }

    virtual ~IApi() = default;
};

} // namespace NInfra::NPodAgent
