#include "common_system_logs_session.h"

#include "system_logs_backend.h"

namespace NInfra::NPodAgent {

void TCommonSystemLogsSession::SendMessage(const TString& message) {
   if (!AtomicGet(MarkEnabled_))
       return;    

   Log_->Write(ELogPriority::TLOG_INFO, message);
}
    
void TCommonSystemLogsSession::MarkEnabled(bool enable) {
    AtomicSet(MarkEnabled_, enable);
}

void TCommonSystemLogsSession::Disable() {
    AtomicSet(MarkEnabled_, false);
}

bool TCommonSystemLogsSession::Enabled() const {
    return AtomicGet(MarkEnabled_);
}

i64 TCommonSystemLogsSession::GetBytesSent() const {
    i64 receivedBytes = Counters_->ReceivedBytes.Val();
    Counters_->ReceivedBytes.Sub(receivedBytes);
    return receivedBytes;
}

i64 TCommonSystemLogsSession::GetBytesDropped() const {
    i64 droppedBytes = Counters_->DroppedBytes.Val();
    Counters_->DroppedBytes.Sub(droppedBytes);
    return droppedBytes;
}

} // namespace NInfra::NPodAgent
