#pragma once

#include "system_logs_backend.h"
#include "system_logs_session.h"
#include "system_logs_session_parameters.h"

#include <util/generic/maybe.h>

namespace NInfra::NPodAgent {

class TCommonSystemLogsSession;
using TCommonSystemLogsSessionPtr = TIntrusivePtr<TCommonSystemLogsSession>;

class TCommonSystemLogsSession: public ISystemLogsSession {
public:
    TCommonSystemLogsSession()
        : MarkEnabled_(false)
        , Counters_(new NUnifiedAgent::TClientSessionCounters())
        , Parameters_(MakeHolder<TSystemLogsSessionParameters>("", "", Counters_))
        , Log_(MakeHolder<TLog>(std::move(MakeSystemLogBackend((*Parameters_).GetClientParameters(), (*Parameters_).GetSessionParameters()))))
    {
    }

    virtual ~TCommonSystemLogsSession() = default;

    virtual void SendMessage(const TString& message) override;
    virtual void MarkEnabled(bool enable) override;
    virtual void Disable() override;
    virtual bool Enabled() const override;
    virtual i64 GetBytesSent() const override;
    virtual i64 GetBytesDropped() const override;

private:
    TAtomic MarkEnabled_;
    TIntrusivePtr<NUnifiedAgent::TClientSessionCounters> Counters_;
    THolder<TSystemLogsSessionParameters> Parameters_;
    THolder<TLog> Log_;
};

} // namespace NInfra::NPodAgent
