#pragma once

#include "system_logs_sender.h"

namespace NInfra::NPodAgent {

using NThreading::TFuture;

class TMockSystemLogsSender;
using TMockSystemLogsSenderPtr = TIntrusivePtr<TMockSystemLogsSender>;

class TMockSystemLogsSender: public ISystemLogsSender {
public:
    virtual ~TMockSystemLogsSender() = default;
    
    virtual void Add(const TString&, TSystemLogsSessionPtr) override { }
    virtual void Remove(const TString&) override { }
    virtual void RemoveAll() override { }
    virtual bool Has(const TString&) const override { return false; }
    virtual void MarkEnabled(bool ) override { }
    virtual bool GetMarkEnabled() const override { return false; }
    virtual TFuture<TExpected<void, TSystemLogsSenderError>> SendMessage(const TString&, const TString&) override {
        auto result = NThreading::NewPromise<TExpected<void, TSystemLogsSenderError>>();
        result.SetValue(TExpected<void, TSystemLogsSenderError>::DefaultSuccess());
        return result;
    }
};

} // namespace NInfra::NPodAgent
