#pragma once

#include "system_logs_session.h"

namespace NInfra::NPodAgent {

class TMockSystemLogsSession;
using TMockSystemLogsSessionPtr = TIntrusivePtr<TMockSystemLogsSession>;

class TMockSystemLogsSession: public ISystemLogsSession {
public:
    TMockSystemLogsSession()
    {
    }

    virtual ~TMockSystemLogsSession() = default;

    virtual void SendMessage(const TString&) override { }
    virtual void MarkEnabled(bool) override { }
    virtual void Disable() override { }
    virtual bool Enabled() const override { return false; }
    virtual i64 GetBytesSent() const override { return 0; }
    virtual i64 GetBytesDropped() const override { return 0; }
};

} // namespace NInfra::NPodAgent
