#pragma once

#include "system_logs_session_collection.h"

#include <infra/libs/outcome/result.h>

#include <util/generic/map.h>

namespace NInfra::NPodAgent {

class TOneSystemLogsSessionCollection;
using TOneSystemLogsSessionCollectionPtr = TIntrusivePtr<TOneSystemLogsSessionCollection>;

class TOneSystemLogsSessionCollection: public ISystemLogsSessionCollection {
public:
    TOneSystemLogsSessionCollection(TSystemLogsSessionPtr systemLogsSession)
        : SystemLogsSession_(systemLogsSession)
    {
    }

    void Add(const TString& objectId, TSystemLogsSessionPtr) override;
    void Remove(const TString& objectId) override;
    void RemoveAll() override;
    TExpected<TSystemLogsSessionPtr, TSystemLogsSenderError> Get(const TString& objectId) const override;
    TVector<TSystemLogsSessionPtr> GetAll() const override;
    size_t GetEnabledSessionsCount() const override;
    size_t GetDisabledSessionsCount() const override;

private:
    TSystemLogsSessionPtr SystemLogsSession_;
};

} // namespace NInfra::NPodAgent
