#include "mock_system_logs_session.h"
#include "one_system_logs_session_collection.h"

#include <library/cpp/testing/unittest/registar.h>

#include <util/system/thread.h>

namespace NInfra::NPodAgent::NTestOneSystemLogsSessionCollection {

Y_UNIT_TEST_SUITE(OneSystemLogsSessionCollectionSuite) {

Y_UNIT_TEST(TestSessionCollectionAddGetRemove) {
    TSystemLogsSessionPtr systemLogsSession = new TMockSystemLogsSession();
    TSystemLogsSessionCollectionPtr sessionCollection = new TOneSystemLogsSessionCollection(systemLogsSession);

    UNIT_ASSERT_EQUAL((bool)(sessionCollection->Get("object_id_1")), true);
    UNIT_ASSERT_EQUAL(sessionCollection->GetAll().size(), 1);
    
    sessionCollection->Add("object_id_1", systemLogsSession);
    sessionCollection->Add("object_id_2", systemLogsSession);
  
    UNIT_ASSERT_EQUAL(sessionCollection->GetAll().size(), 1);
        
    sessionCollection->RemoveAll();
    UNIT_ASSERT_EQUAL(sessionCollection->GetAll().size(), 1);

    UNIT_ASSERT_EQUAL((bool)(sessionCollection->Get("object_id_1")), true);
}

}

} // namespace NInfra::NPodAgent::NTestOneSystemLogsSessionCollection
